from qb2.api.v1.typing import Struct, Optional, Bool, Integer, String, List, UInt64, Json, Dict


OUTPUT_PATH = "//home/videoquality/video_wizard_cube"

KP_SCHEMA = Struct[
    "expandable": Optional[Bool],
    "kp_count": Optional[Integer],
    "borders": Optional[String],
    "clicks_pos": Optional[String],
    "clicks_count": Optional[Integer],
    "source": Optional[String]
]

REDUCE_SCHEMA = Struct[
    "pos": Integer,
    "clicks": Integer,
    "id": UInt64,
    "duplicates_ids": List[UInt64],
    "keypoints": Optional[KP_SCHEMA]
]

SCHEMA = {
    "uid": String,
    "ts": Integer,
    "ReqID": String,
    "query": String,
    "norm_query": String,
    "ui": String,
    "domain": String,
    "url": String,
    "referer": String,
    "UserAgent": String,
    "UserRegion": Integer,
    "ICookie": String,
    "wiz_name": String,
    "wiz_type": String,
    "wiz_pos": Integer,
    "title_clicks_count": Integer,
    "video_clicks_count": Integer,
    "keypoints_clicks_count": Integer,
    "other_clicks_count": Integer,
    "wiz_results": List[REDUCE_SCHEMA],
    "has_keypoints": Bool,
    "has_fragment": Bool,
    "has_translations": Bool,
    "translations_title_clicks_count": Integer,
    "translations_videos": List[REDUCE_SCHEMA],
    "testids": List[String],
    "triggered_testids": List[String],
    "SearchPropsValues": Json,
    "RelevValues": Dict[String, String]
}

SPV_FIELDS = [
    "REPORT.ya_plus",
    "REPORT.user_subscription",
    "UPPER.PrismBigBLog.prism_cluster",
    "UPPER.PrismBigBLog.prism_segment",
    "WEB.Porno.pl"
]

RV_FIELDS = [
    "vserial",
    "vseason",
    "vepisode",
    "vsertitle",
    "vsexact",
    "is_memorandum_query",
    "mu",
    "mut",
    "is_music_ext",
    "ismusic",
]
