def get_block_clicks_count(block, joiners):
    import baobab
    return len([
        x
        for joiner in joiners
        for x in joiner.get_events_by_block(block)
        if isinstance(x, baobab.common.Click)
    ])


def get_block_subtree_clicks_count(block, joiners):
    import baobab
    return len([
        x
        for joiner in joiners
        for x in joiner.get_events_by_block_subtree(block)
        if isinstance(x, baobab.common.Click)
    ])


def check_video_has_fragment_desktop(video):
    return "fragment" in video.attrs


def parse_video_clicks_count(video, joiners):
    import baobab
    video_clicks_count = 0
    for child in baobab.common.children_iterator(video):
        if child.name in ("thumb", "host", "title"):
            video_clicks_count += get_block_subtree_clicks_count(child, joiners)
    return video_clicks_count


def parse_translations_desktop(translations_block, joiners):
    import baobab

    title_clicks_count = 0
    translations_videos = []
    for child in baobab.common.children_iterator(translations_block):
        if child.name != "scroller":
            if child.name == "title":
                title_clicks_count += get_block_clicks_count(child, joiners)
            continue
        for subchild in baobab.common.children_iterator(child):
            if subchild.name == "item" and check_video_has_ids(subchild):
                video_row = parse_video_desktop(subchild, joiners)
                translations_videos.append(video_row)

    return title_clicks_count, translations_videos


def parse_video_desktop(video, joiners):
    video_clicks_count = parse_video_clicks_count(video, joiners)

    video_ids = video.attrs["ids"]

    video_row = {
        "id": int(video_ids[0]),
        "duplicates_ids": list(map(int, video_ids[1:])),
        "pos": video.attrs["item"],
        "clicks": video_clicks_count
    }
    return video_row


def check_video_has_ids(video):
    return video.attrs.get("ids") and len(video.attrs.get("ids")) > 0


def check_video_has_keypoints_desktop(video):
    import baobab

    item_has_kp = False
    for child in baobab.common.children_iterator(video):
        if "keypoints" in child.name:
            item_has_kp = True
            break

    return item_has_kp


def parse_keypoint_event(kp_event, keypoints, kp_clicks):
    import baobab
    if isinstance(kp_event, baobab.common.Tech) and kp_event.type == "show":
        keypoints["kp_expandable"] = kp_event.data.get("expandable", False)
        keypoints["kp_count"] = kp_event.data.get("count", -1)
        keypoints["kp_borders"] = kp_event.data.get("times", "")
        keypoints["source"] = kp_event.data.get("source", "")
    elif isinstance(kp_event, baobab.common.Click):
        kp_click = kp_event.data.get("index")
        kp_clicks.append(str(kp_click))


def parse_video_with_keypoints_desktop(video, joiners, marks):
    import baobab

    video_clicks_count = parse_video_clicks_count(video, joiners)
    kp_blocks = marks.get_blocks("wizard_video_showcase_item_keypoints_items")
    kp_clicks = []

    video_children_ids = set(child.id for child in baobab.common.children_iterator(video))
    keypoints = {}

    for kp_block in kp_blocks:
        if kp_block.id not in video_children_ids:
            continue
        kp_joiner = marks.get_joiner_by_block_id(kp_block.id)
        kp_events = kp_joiner.get_events_by_block(kp_block)
        for kp_event in kp_events:
            parse_keypoint_event(kp_event, keypoints, kp_clicks)

    keypoints["clicks_pos"] = ";".join(kp_clicks)
    keypoints["clicks_count"] = len(kp_clicks)

    video_ids = video.attrs["ids"]
    video_row = {
        "id": int(video_ids[0]),
        "duplicates_ids": list(map(int, video_ids[1:])),
        "pos": video.attrs["item"],
        "clicks": video_clicks_count,
        "keypoints": keypoints
    }

    return video_row


def add_video_results_info_desktop(res, block, joiners, marks):
    import baobab

    title_clicks_count = 0
    video_clicks_count = 0
    keypoints_clicks_count = 0
    other_clicks_count = 0
    has_keypoints = False
    has_fragments = False
    has_translations = False
    wiz_results = []
    translations_title_clicks_count = 0
    translations_videos = []

    try:
        wiz_block = next(baobab.common.children_iterator(block))
    except StopIteration:
        return

    for item_block in baobab.common.children_iterator(wiz_block):
        new_total_video_clicks_cnt = get_block_subtree_clicks_count(item_block, joiners)
        if item_block.name != "item":
            if item_block.name == "title":
                title_clicks_count += new_total_video_clicks_cnt
            elif item_block.name == "translations":
                has_translations = True
                translations_title_clicks_count, translations_videos = parse_translations_desktop(
                    item_block, joiners)
            else:
                other_clicks_count += new_total_video_clicks_cnt
            continue

        if check_video_has_fragment_desktop(item_block):
            has_fragments = True

        item_has_ids = check_video_has_ids(item_block)
        item_has_kp = check_video_has_keypoints_desktop(item_block)

        new_kp_clicks_count = 0
        if item_has_ids:
            if item_has_kp:
                has_keypoints = True
                video_row = parse_video_with_keypoints_desktop(item_block, joiners, marks)
                new_kp_clicks_count = video_row["keypoints"].get("clicks_count", 0)
            else:
                video_row = parse_video_desktop(item_block, joiners)
        else:
            continue

        keypoints_clicks_count += new_kp_clicks_count
        video_clicks_count += video_row["clicks"]

        wiz_results.append(video_row)

    res["title_clicks_count"] = title_clicks_count
    res["video_clicks_count"] = video_clicks_count
    res["keypoints_clicks_count"] = keypoints_clicks_count
    res["other_clicks_count"] = other_clicks_count
    res["wiz_results"] = wiz_results
    res["translations_title_clicks_count"] = translations_title_clicks_count
    res["translations_videos"] = translations_videos
    res["has_keypoints"] = has_keypoints
    res["has_fragment"] = has_fragments
    res["has_translations"] = has_translations
