from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf
import argparse
import nile
import datetime
import uatraits, json, re
import urllib, urlparse
import math,cgi
import pandas as pd
from itertools import product
import sys
import os


def parse_oo_data(records):
    domain = 'ru'
    for r in records:
        value = json.loads(r.value)
        o_type = value.get('isa', {}).get('otype')
        o_type_value = [x['value'] for x in o_type if 'value' in x] if o_type else []
        o_type_subvalue = [x['subvalue'] for x in o_type if 'subvalue' in x] if o_type else []

        elems = {}
        k, v  = ('query', "SearchRequest")
        elems[k] = [x["value"] for x in value.get(v, []) if domain in x.get("RelevLocale", [])]
        elems[k] = elems[k][0] if elems[k] else None
        if not elems['query']:
            continue

        yield Record(onto_id=r.key, oo_query=elems['query'],ttype=o_type_value)

def process_data_for_stat(date):

    cluster = clusters.yt.Hahn(
    ).env(templates=dict(job_root='home/videolog/vika-pavlova/2342-film_queries_with_ontoids'
                        ),
          yt_spec_defaults=dict(pool_trees=["physical"],
                                tentative_pool_trees=["cloud"]
                               ),
          parallel_operations_limit=10
         )
    job = cluster.job()

    reqs = job.table('home/videolog/vika-pavlova/one_us_parse_for_all_reports/2082_2184_vh_' + date)

    aggr = reqs.filter(sf.contains('ui', 'web')
                      ).groupby('ui','object_id', 'date'
                               ).aggregate(reqs=na.count(),
                                           vh_tvt=na.sum('vh_tvt'),
                                           other_tvt=na.sum('other_tvt'),
                                           vid_clicks=na.sum('vid_clicks'),
                                           other_clicks=na.sum('other_clicks')
                                          )

    t = job.table('home/videoindex/full/video_hosting/episodes'
                 ).filter(sf.defined('onto_id'))

    tt = t.groupby('onto_id').aggregate(urls=na.count()
                                       ).sort('urls')


    join_onto_ids = tt.join(aggr, by_left = 'onto_id', by_right = 'object_id', type ='right'
                           ).project('date', 'object_id', 'reqs', 'vh_tvt', 'vid_clicks', 'other_clicks',
                                     'other_tvt', 'ui',
                                     vh_filter = ne.custom(lambda x: 'is_vh' if x else 'not_vh', 'onto_id')
                                    )

    cards = job.table('home/dict/ontodb/ver/daily/production/all_cards_final'
            ).map(parse_oo_data,memory_limit=4000)

    final = cards.join(join_onto_ids, by_left = 'onto_id', by_right = 'object_id', type ='inner'
                      ).project('date', 'object_id', 'reqs', 'vh_tvt', 'vid_clicks', 'other_clicks',
                                'other_tvt', 'ui','vh_filter', 'oo_query', 'ttype'
                               )


    final.filter(sf.custom(lambda x: 'Film' in x, 'ttype')
                ).sort('object_id').put('$job_root/film_queries_' + date)

    job.run()

def main():

    parser = argparse.ArgumentParser()
    parser.add_argument('--start_date', type=str, required=True)
    parser.add_argument('--end_date', type=str, required=True)
    args = parser.parse_args()

    for date in pd.date_range(start=args.start_date, end=args.end_date):
        date_str = str(date)[:10]
        process_data_for_stat(date_str)


if __name__ == '__main__':
    main()
