# -*- coding: utf-8 -*-
from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf
import argparse
import nile
import datetime
import uatraits, json, re
import urllib, urlparse
import math, cgi
import pandas as pd
from itertools import product
import sys
import os


def recs_combination(recs):

    for rec in recs:

        recs_list = list(product(
            (rec.platform, '_total_'),
            (rec.player_id, '_total_')))

        for pair in recs_list:
            yield Record(platform=pair[0], player_id=pair[1],
                         fielddate = rec.date, uid = rec.uid, reqid = rec.reqid, url = rec.url,
                         tvt = rec.tvt, lvt = rec.lvt, view = rec.view,
                         has_open = rec.has_open, has_inited = rec.has_inited,
                         has_started = rec.has_started, has_adShown = rec.has_adShown,
                         has_adEnd = rec.has_adEnd, has_paused = rec.has_paused,
                         has_resumed = rec.has_resumed, has_rewound = rec.has_rewound,
                         has_ended = rec.has_ended
                        )

def process_data_for_stat(date):

    cluster = clusters.yt.Hahn(pool='vika-pavlova'
    ).env(templates=dict(job_root='//home/videolog/vika-pavlova/3996-tech_events'
                        ),
          yt_spec_defaults=dict(pool_trees=["physical"],
                                tentative_pool_trees=["cloud"]),
          parallel_operations_limit=10
         )

    job = cluster.job()

    parsed = job.table('home/videolog/vika-pavlova/one_us_parse_for_all_reports/3996_player_events_' + date
                      ).project(ne.all(exclude='player_id'),
                                player_id = ne.custom(lambda x: x if x else 'other', 'player_id')
                               ).map(recs_combination, memory_limit = 4000
                                    )

    parsed.groupby('platform', 'player_id', 'fielddate'
                  ).aggregate(urls=na.count(),
                              tvt = na.sum('tvt'),
                              lvt = na.sum('lvt'),
                              views = na.sum('view'),
                              open_count = na.sum('has_open'),
                              inited_count = na.sum('has_inited'),
                              started_count = na.sum('has_started'),
                              adshown_count = na.sum('has_adShown'),
                              adend_count = na.sum('has_adEnd'),
                              paused_count = na.sum('has_paused'),
                              resumed_count = na.sum('has_resumed'),
                              rewound_count = na.sum('has_rewound'),
                              ended_count = na.sum('has_ended')
                              ).put('$job_root/final_' + date)

    job.run()


def put_data_to_stat(date):

    client = ns.StatfaceClient(
        proxy = 'upload.stat.yandex-team.ru',
        token = os.environ['STAT_TOKEN']
    )
    ns.StatfaceReport().path('Video.All/player_events_stat') \
                       .scale('daily') \
                       .client(client) \
                       .remote_publish(proxy='hahn',
                                       table_path='//home/videolog/vika-pavlova/3996-tech_events/final_' + date,
                                       async_mode=False,
                                       upload_config=False)


def main():

    parser = argparse.ArgumentParser()
    parser.add_argument('--start_date', type=str, required=True)
    parser.add_argument('--end_date', type=str, required=True)
    args = parser.parse_args()

    for date in pd.date_range(start=args.start_date, end=args.end_date):
        date_str = str(date)[:10]
        process_data_for_stat(date_str)
        put_data_to_stat(date_str)


if __name__ == '__main__':
    main()
