# -*- coding: utf-8 -*-

import math
import re
import json

class ScenarioAccuracy:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        video_scenario = metric_params.serp_data.get('judgements.scenario_type', {}).get('name')
        alice_scenario = metric_params.serp_data.get('judgements.display_type', {}).get('name')
        query = metric_params.serp_data.get("query", {}).get('text')

        if not video_scenario or video_scenario in ['PLAYER_ACTION', 'MUSIC', 'JUNK', "CHANNEL"]:
            return -1

        if video_scenario == 'FILM_CARD' and ('youtube' not in query and u'ютуб' not in query):
            if alice_scenario in ['show_pay_push_screen', 'video_play', 'show_description']:
                return 1
            else:
                return 0
        elif video_scenario == 'FILM_CARD' and ('youtube' in query or u'ютуб' in query):
            if alice_scenario in ['video_search_gallery']:
                return 1
            else:
                return 0
        elif video_scenario == 'COLLECTION':
            if alice_scenario in ['show_gallery', 'video_search_gallery', 'movie_search_gallery', 'tv_show_search_gallery']:
                return 1
            else:
                return 0
        elif video_scenario == 'CHANNEL':
            if alice_scenario == 'show_tv_gallery':
                return 1
            else:
                return 0
        elif video_scenario == "OTHER_VIDEO":
            if alice_scenario == 'video_search_gallery':
                return 1
            else:
                return 0
        else:
            return -1

class VideoRelevance:
    def __init__(self, depth=5, scenario_fine=0.1, channel_flag=0):
        self.depth = depth
        self.scenario_fine = scenario_fine
        self.channel_flag = channel_flag

    def value(self, metric_params):

        def scenario_accuracy(metric_params):

            coef = 1.0

            video_scenario = metric_params.serp_data.get('judgements.scenario_type', {}).get('name')
            alice_scenario = metric_params.serp_data.get('judgements.display_type', {}).get('name')
            query = metric_params.serp_data.get("query", {}).get('text')

            if (video_scenario == 'FILM_CARD' and ('youtube' not in query and u'ютуб' not in query)) and \
                (alice_scenario not in ['show_pay_push_screen', 'video_play', 'show_description']):
                coef = (1 - self.scenario_fine)
            elif (video_scenario == 'FILM_CARD' and ('youtube' in query or u'ютуб' in query)) and \
                (alice_scenario not in ['video_search_gallery']):
                coef = (1 - self.scenario_fine)
            elif video_scenario == 'COLLECTION' and alice_scenario not in ['show_gallery', 'video_search_gallery', 'movie_search_gallery', 'tv_show_search_gallery']:
                coef = (1 - self.scenario_fine)
            elif video_scenario == 'CHANNEL' and alice_scenario != 'show_tv_gallery':
                coef = (1 - self.scenario_fine)
            elif video_scenario == "OTHER_VIDEO" and alice_scenario != 'video_search_gallery':
                coef = (1 - self.scenario_fine)

            return coef

        video_scenario = metric_params.serp_data.get('judgements.scenario_type', {}).get('name')
        if not video_scenario or video_scenario in ['PLAYER_ACTION', 'MUSIC', 'JUNK']:
            return -1

        results = metric_params.results[:self.depth]
        res_len = min(len(results),self.depth)

        if res_len == 0:
            return 0
        else:
            max_dcg = 1.0 * sum([1.0 / math.log(2 + pos) for pos in range(res_len)])
            coef = scenario_accuracy(metric_params)

            dcg = 0
            for res in results:
                pos_index = res.pos
                relevance = 1 if res.scales.get('relevance', '404') == "rel_plus" else 0
                dcg += coef * relevance / math.log(1 + pos_index)

            if self.channel_flag == 1 and metric_params.serp_data.get('judgements.scenario_type', {}).get('name') == 'CHANNEL':
                return -1
            else:
                return dcg / max_dcg

class ErrorShare:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        bad = 0
        total = 0

        for res in results:
            total += 1
            if res.scales.get('relevance', '') == "404":
                bad += 1

        if total:
            return (bad * 100.) / total
        else:
            return -1

class YangVideoRelevance:
    def __init__(self, depth=5, scenario_fine=0.1, channel_flag=0):
        self.depth = depth
        self.scenario_fine = scenario_fine
        self.channel_flag = channel_flag

    def value(self, metric_params):

        def scenario_accuracy(metric_params):

            print "query is %s" %(metric_params.serp_data.get("query", {}).get('text'))

            coef = 1.0

            video_scenario = metric_params.serp_data.get('judgements.scenario_type', {}).get('name')
            alice_scenario = metric_params.serp_data.get('judgements.display_type', {}).get('name')
            query = metric_params.serp_data.get("query", {}).get('text')

            if (video_scenario == 'FILM_CARD' and ('youtube' not in query and u'ютуб' not in query)) and \
                (alice_scenario not in ['show_pay_push_screen', 'video_play', 'show_description']):
                coef = (1 - self.scenario_fine)
            elif (video_scenario == 'FILM_CARD' and ('youtube' in query or u'ютуб' in query)) and \
                (alice_scenario not in ['video_search_gallery']):
                coef = (1 - self.scenario_fine)
            elif video_scenario == 'COLLECTION' and alice_scenario not in ['show_gallery', 'video_search_gallery', 'movie_search_gallery', 'tv_show_search_gallery']:
                coef = (1 - self.scenario_fine)
            elif video_scenario == 'CHANNEL' and alice_scenario != 'show_tv_gallery':
                coef = (1 - self.scenario_fine)
            elif video_scenario == "OTHER_VIDEO" and alice_scenario != 'video_search_gallery':
                coef = (1 - self.scenario_fine)

            return coef

        video_scenario = metric_params.serp_data.get('judgements.scenario_type', {}).get('name')
        if not video_scenario or video_scenario in ['PLAYER_ACTION', 'MUSIC', 'JUNK']:
            return -1

        results = metric_params.results[:self.depth]
        res_len = min(len(results),self.depth)

        if res_len == 0:
            return 0
        else:
            max_dcg = 1.0 * sum([1.0 / math.log(2 + pos) for pos in range(res_len)])
            coef = scenario_accuracy(metric_params)

            dcg = 0
            for res in results:
                pos_index = res.pos
                relevance_value = {
                    'RELEVANT_PLUS': 1.0,
                    'RELEVANT_MINUS': 0.5,
                    'IRRELEVANT': 0.0,
                    'SOFT_404': 0.0,
                    '_404': 0.0,
                    'VIRUS' : 0.0,
                    'not_found': 0.0
                    }
                print "rel is %s" %(res.scales.get('yang_relevance', '_404'))
                relevance = relevance_value[res.scales.get('yang_relevance', '_404')]
                dcg += coef * relevance / math.log(1 + pos_index)

            if self.channel_flag == 1 and metric_params.serp_data.get('judgements.scenario_type', {}).get('name') == 'CHANNEL':
                return -1
            else:
                return dcg / max_dcg


class NotFoundShare:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        not_found = 0

        for res in results:
            if res:
                total += 1
                if res.scales.get('yang_relevance', '_404') == "not_found":
                    not_found += 1

        if total:
            return not_found * 1. / total
        else:
            return -1

class YangSoft404Share:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        bad = 0
        total = 0

        for res in results:
            total += 1
            if res.scales.get('yang_relevance', '') == "SOFT_404":
                bad += 1

        if total:
            return (bad * 100.) / total
        else:
            return -1

class Yang404Share:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        bad = 0
        total = 0

        for res in results:
            total += 1
            if res.scales.get('yang_relevance', '') == "_404":
                bad += 1

        if total:
            return (bad * 100.) / total
        else:
            return -1
