class rel_share:

    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        rel = 0
        total = 0

        for res in results:
            if 'video_relevance_bin' in res.scales:
                total += 1
                if res.scales['video_relevance_bin'] == 'REL':
                    rel += 1

        if total:
            return rel * 100.0 / total

class irrel_share:

    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        irrelevant = 0
        total = 0

        for res in results:
            if 'video_relevance_bin' in res.scales:
                total += 1
                if res.scales['video_relevance_bin'] == 'NOT_REL':
                    irrelevant += 1

        if total:
            return irrelevant * 100.0 / total

class not_found_share:

    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        count_404 = 0
        total = 0

        for res in results:
            if 'video_relevance_bin' in res.scales:
                total += 1
                if res.scales['video_relevance_bin'] == '404':
                    count_404 += 1

        if total:
            return count_404 * 100.0 / total
