import math

class VideoPopularity:
    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        max_dcg = sum([1.0 / math.log(2 + pos) for pos in range(self.depth)])

        dcg = 0

        for res in results:

            pos_index = res.pos
            assert (pos_index >= 1)

            relevance = res.scales.get('video_relevance', '_404')

            if relevance != 'RELEVANT_PLUS':
                continue

            dcg += res.scales.get('popularity_prediction', 0) / math.log(1 + pos_index)

        return dcg / max_dcg
