import math
import urlparse

class VideoQuality:
    def __init__(self, depth = 5, desktop_norm_weight = 0.7, touch_norm_weight = 1):

        self.depth = depth
        self.desktop_norm_weight = desktop_norm_weight
        self.touch_norm_weight = touch_norm_weight

    def value(self, metric_params):

        def num_value(label, norm_weight):
            v = {'OK': 1.0, 'NORM': norm_weight, 'BAD': 0.0, '_404': 0.0}

            return v[label]

        def get_quality_names(serp_data):
            host = urlparse.urlparse(serp_data["headers"]["cleanUrl"]).netloc

            if "yandex" in host:
                return "video_quality"
            elif "google" in host:
                return "video_quality_google"
            else:
                return "unknown_system"

        def get_quality(res, metric_params):
            video_quality_name = get_quality_names(metric_params.serp_data)

            if video_quality_name == "unknown_system":
                raise Exception
                return 0

            IS_DESKTOP = 0
            is_desktop = metric_params.query_device == IS_DESKTOP

            if is_desktop:
                video_quality = num_value(res.scales.get(video_quality_name, '_404'), self.desktop_norm_weight)
            else:
                video_quality = num_value(res.scales.get(video_quality_name, '_404'), self.touch_norm_weight)

            return video_quality

        results = metric_params.results[:self.depth]

        max_dcg = sum([1.0 / math.log(2 + pos) for pos in range(self.depth)])

        dcg = 0

        for res in results:

            pos_index = res.pos
            assert (pos_index >= 1)

            relevance = res.scales.get('video_relevance', '_404')

            if relevance != 'RELEVANT_PLUS':
                continue

            dcg += get_quality(res, metric_params) / math.log(1 + pos_index)

        return dcg / max_dcg
