import json
import math

class feed_pointwise_avg_score_video:

    def __init__(self, depth=1, flag = 0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]
        params = json.loads(str(metric_params.serp_data.get("query_param.action_count", {})))

        total_assessments = 0

        assessments_sum = 0

        for res in results:
            if not res.scales['collections_feed_pointwise_label']:
                continue
            total_assessments += 1
            assessments_sum += int(res.scales['collections_feed_pointwise_label'])

        if total_assessments:
            if self.flag == 0:
                metric = assessments_sum * 1.0 / total_assessments
            elif self.flag == 1:
                coef = params['weight'] * params['tolokers_count'] / params['total_weight']
                metric = (assessments_sum * 1.0 / total_assessments) * coef
            else:
                if params['action'] < 10:
                    return -1
                else:
                    metric = (assessments_sum * 1.0 / total_assessments)

            if metric == -1:
                return -1.00001
            elif metric == -2:
                return -2.00001
            else:
                return metric


class feed_pointwise_avg_score_dcg:

    def __init__(self, depth=1, flag = 0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]
        params = json.loads(str(metric_params.serp_data.get("query_param.action_count", {})))

        assessments_sum = 0

        max_dcg = 2.0 * sum([1.0 / math.log(2 + pos) for pos in range(self.depth)])

        pos = 1
        for res in results:

            if not res.scales['collections_feed_pointwise_label']:
                continue
            assessments_sum += int(res.scales['collections_feed_pointwise_label']) / math.log(1 + pos)

            pos += 1

        print "depth is %d" %(self.depth)
        print 'recom len is %d' %len(results)
        print "uid is %s" %(metric_params.serp_data.get("query")["text"])
        print 'max dcg is %f' %max_dcg
        print 'assessments_sum is %f' %assessments_sum

        metric = assessments_sum * 1.0 / max_dcg

        if metric == -1:
            return -1.00001
        elif metric == -2:
            return -2.00001
        else:
            return metric

class feed_pointwise_avg_score_discounted:

    def __init__(self, depth=1, flag = 0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]
        params = json.loads(str(metric_params.serp_data.get("query_param.action_count_discounted", {})))
        is_discount = metric_params.serp_data.get("query_param.discount_filter", 'no')

        total_assessments = 0

        assessments_sum = 0

        for res in results:
            if not res.scales['collections_feed_pointwise_label']:
                continue
            total_assessments += 1
            assessments_sum += int(res.scales['collections_feed_pointwise_label'])

        if is_discount == 'yes':
            return -1
        else:
            if total_assessments:
                if self.flag == 0:
                    metric = assessments_sum * 1.0 / total_assessments
                elif self.flag == 1:
                    coef = params['weight'] * params['tolokers_count'] / params['total_weight']
                    metric = (assessments_sum * 1.0 / total_assessments) * coef
                else:
                    if params['action'] < 10:
                        return -1
                    else:
                        metric = (assessments_sum * 1.0 / total_assessments)

                if metric == -1:
                    return -1.00001
                elif metric == -2:
                    return -2.00001
                else:
                    return metric


class bad_assessment:

    def __init__(self, depth=1):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total_assessments = 0
        bad_assessments = 0

        for res in results:
            if not res.scales['collections_feed_pointwise_label']:
                continue
            total_assessments += 1
            if  res.scales['collections_feed_pointwise_label'] == "-1":
                bad_assessments += 1

        if total_assessments:
           return bad_assessments * 100.0 / total_assessments
        else:
            return -1

class worst_assessment:

    def __init__(self, depth=1):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total_assessments = 0
        worst_assessments = 0

        for res in results:
            if not res.scales['collections_feed_pointwise_label']:
                continue
            total_assessments += 1
            if  res.scales['collections_feed_pointwise_label'] in ["-1", "-2"]:
                worst_assessments += 1

        if total_assessments:
           return worst_assessments * 100.0 / total_assessments
        else:
            return -1
