class NonPlayableFreshResults:
    def __init__(self, depth=5, vdpType = 'factor_vdp'):
        self.Depth = depth
        self.VdpType = vdpType

    # metric value for one serp
    def value(self, metric_params):
        np = 0.
        docs = 0.

        for index, result in enumerate(metric_params.results[:self.Depth]):
            if not result.scales.get("webadd", {}).get("hasVideoPlayer", False):
                continue
            if result.scales.get('text.SERVER_DESCR', '') != 'VIDEOQUICK':
                continue
            vdp_mark = result.scales.get(self.VdpType, 'OK')
            if vdp_mark != 'OK':
                np += 1
            docs += 1

        if docs > 0 :
            return np / docs
        else :
            return None
