class rel_plus_share:

    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        rel_plus = 0
        total = 0

        for res in results:
            if res.scales['video_relevance']:
                total += 1
                if res.scales['video_relevance'] == 'RELEVANT_PLUS':
                    rel_plus += 1

        if total:
            return rel_plus * 100.0 / total

class rel_minus_share:

    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        rel_minus = 0
        total = 0

        for res in results:
            if res.scales['video_relevance']:
                total += 1
                if res.scales['video_relevance'] == 'RELEVANT_MINUS':
                    rel_minus += 1

        if total:
            return rel_minus * 100.0 / total

class irrel_share:

    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        irrelevant = 0
        total = 0

        for res in results:
            if res.scales['video_relevance']:
                total += 1
                if res.scales['video_relevance'] == 'IRRELEVANT':
                    irrelevant += 1

        if total:
            return irrelevant * 100.0 / total

class not_found_share:

    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        count_404 = 0
        total = 0

        for res in results:
            if res.scales['video_relevance']:
                total += 1
                if res.scales['video_relevance'] in ['SOFT_404', '_404']:
                    count_404 += 1

        if total:
            return count_404 * 100.0 / total
