class content_types_metric:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        types_set = set()

        for res in results:
            if not res.scales.get("text.supertag"):
                types_set.add('other')
            else:
                types_set.add(res.scales.get("text.supertag"))

        # metric - average count of different types in recommendations
        if self.flag == 0:
            return len(types_set)
        # metric - share of documents having only 1 type of content in recommendations
        elif self.flag == 1:
            if len(types_set) == 1:
                return 100
            else:
                return 0
        # metric - share of documents having 2 types of content in recommendations
        elif self.flag == 2:
            if len(types_set) == 2:
                return 100
            else:
                return 0
        # metric - share of documents having 3 types of content in recommendations
        elif self.flag == 3:
            if len(types_set) == 3:
                return 100
            else:
                return 0
        # metric - share of documents having 4 types of content in recommendations
        elif self.flag == 4:
            if len(types_set) == 4:
                return 100
            else:
                return 0


class years_count_metric:

    def __init__(self, depth=1):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        years_set = set()

        for res in results:
            if res.scales.get("text.supertag") == 'movie' or res.scales["text.supertag"] == 'series' and res.scales['text.release_year']:
                years_set.add(res.scales['text.release_year'])

        return len(years_set)


class mean_duration_metric:

    def __init__(self, depth=1):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        duration_list = []

        for res in results:
            if not res.scales['text.duration']:
                continue
            duration_list.append(int(res.scales['text.duration']))

        if duration_list:
            return (sum(duration_list) * 1. / len(duration_list)) / 3600
        else:
            return -1


class decade_count_metric:

    def __init__(self, depth=1):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        decades_set = set()

        for res in results:
            if res.scales.get("text.supertag") == 'movie' or res.scales["text.supertag"] == 'series' and res.scales['text.release_year']:
                decade = (int(res.scales['text.release_year'])  / 10) * 10
                decades_set.add(decade)

        return len(decades_set)


class blogger_diversity_metric:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        bloggers_set = set()

        for res in results:
            if res.scales.get("text.supertag") == 'blogger' and res.scales.get("json.blogger", {}).get("id", ''):
                blogger_id = res.scales.get("json.blogger", {}).get("id", '')
                bloggers_set.add(blogger_id)

        return len(bloggers_set)
