# -*- coding: utf-8 -*-
from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)
from qb2.api.v1 import extractors as se, filters as sf
import argparse
import nile
import datetime
import json, re
import urllib, urlparse
import math,cgi
import pandas as pd
from itertools import product
import sys
import os
from random import shuffle, sample, random
import time

import json, urllib2, urllib, requests
import codecs, locale
import os, sys, re

cluster = clusters.yt.Hahn(pool='vika-pavlova'
    ).env(templates=dict(job_root='//home/videolog/vika-pavlova/5232-renewability_metrics'
                        ),
          yt_spec_defaults=dict(pool_trees=["physical"],
                                #tentative_pool_trees=["cloud"]),
                                use_default_tentative_pool_trees = True),
          parallel_operations_limit=10
         )

def scrap_recommendation(user, sub, old_recom, url):

    urllib2.unquote(url)
    is_success = False
    try:
        max_tries = 2
        cur_tries = 0
        while not is_success and cur_tries <=  max_tries:
            response = requests.get(
                url,
                verify=False,
            )
            if response.status_code == 200:
                is_success = True
            else:
                time.sleep(10)
            cur_tries += 1
    except:
        print user
        print url


    if not is_success:
        print 'BAD STATUS'
        return {
            "user": user,
            "user_subscription": sub,
            "old_recommendations": old_recom,
            "new_recommendations": []
          }

    data = response.json()

    if data.get("Items", []):
        return {
            "user": user,
            "user_subscription": sub,
            "old_recommendations": old_recom,
            "new_recommendations": [x.get("ObjectId",{}).get("Id", "") for x in data.get("Items", [])],
        }
    else:
        return {
            "user": user,
            "user_subscription": sub,
            "old_recommendations": old_recom,
            "new_recommendations": []
          }

def calc_diff(data, top, carousel, date):

    empty_new_recomms = 0
    empty_old_recomms = 0

    uniq_count = 0
    intersection = 0

    if not data['new_recommendations']:
        empty_new_recomms = 1
    if not data['old_recommendations']:
        empty_old_recomms = 1

    #intersection
    if data['new_recommendations'] and data['old_recommendations']:
        for item in data['new_recommendations'][:top]:
            if item not in data['old_recommendations'][:top]:
                uniq_count += 1

        intersection = len(data['new_recommendations'][:top]) - uniq_count

    # dups count
    old_unique_count = len(data['old_recommendations'][:top])
    if data['old_recommendations'][:top] and len(set(data['old_recommendations'][:top])) != len(data['old_recommendations'][:top]):
        for ontoid in set(data['old_recommendations']):
            if data['old_recommendations'][:top].count(ontoid) == 1:
                old_unique_count += 1
    old_dups_count = len(data['old_recommendations'][:top]) - old_unique_count

    return {
        "user": data["user"],
        "user_subscription": data['user_subscription'] if data['user_subscription'] else 'no_subscription',
        "intersection": intersection * 1. / len(data['new_recommendations'][:top]) if len(data['new_recommendations'][:top]) else 0.0,
        "empty_new_recomms": empty_new_recomms,
        "empty_old_recomms": empty_old_recomms,
        "has_duplicates": 1 if old_dups_count > 0 else 0,
        "old_dups_count": old_dups_count * 1. / len(data['old_recommendations'][:top]) if len(data['old_recommendations'][:top]) else 0.0,
        "old_recommendations": data['old_recommendations'][:top],
        'new_recommendations': data['new_recommendations'][:top],
        "fielddate": date,
        "top": top,
        "carousel": carousel
        }

def find_recommendations(carousel, window, date):

    carousels_cgi = {
        "common": "&query_embedding=AQAAAPg5RsH4OUbBKAAAAK2jfHOUvYB3eoFPW7ConNGoall8rc6YjW1&waitall=da&timeout=10123123",
        "films": "&query_embedding=AQAAAPg5RsH4OUbBKAAAAK%2BYgW%2B94Ydnen9lgcWtm8SZUVR/qORzmmti/2/CPZDGPnlhhop6pxcKAAAA&recommender_parameter=hnsw_index=film&waitall=da&timeout=10123123",
        "series": "&query_embedding=AQAAAPg5RsH4OUbBKAAAAMmhe2HX9H14X5h1rauqpOHKNmGdl99vmC5C/4CqV4bqOF9emV%2BBvjEKAAAA&recommender_parameter=hnsw_index=series&waitall=da&timeout=10123123",
        "anim_films": "&query_embedding=AQAAAPg5RsH4OUbBKAAAALZ3iYqw5LNiU6xmf8N%2B4/CmVFCCxc2YvlNG/3/RIm3dEVpnYn1XyQUKAAAA&recommender_parameter=hnsw_index=anim_film&waitall=da&timeout=10123123",
        "anim_series": "&query_embedding=AQAAAPg5RsH4OUbBKAAAALZzmmeu6apYSLNdmLWC8v/GS0eCuNirwRo1/3TFNVfwFlJjcoRb3AsKAAAA&recommender_parameter=hnsw_index=anim_series&waitall=da&timeout=10123123"
    }

    # gather old recommendations
    puids = []
    uids = []
    for rec in cluster.read('//home/videolog/vika-pavlova/5232-renewability_metrics/recommendations/' + carousel + '_' + window):
        if rec.get("PassportUID", ""):
            puids.append({
              "puid": str(rec["PassportUID"]),
              "sub": rec.get("UserSubscription", ""),
              "recom": rec.get("recommendations", ""),
              })
        else:
            uids.append({
              "uid": str(rec["UID"]),
              "sub": rec.get("UserSubscription", ""),
              "recom": rec.get("recommendations", ""),
              })

    # gather new recommendations
    all_users = []
    for item in puids:
        url_1 = 'http://entitysearch.yandex.net/entity/recommend?experiment=recommend_films&source=nmeta&format=json'
        url_1 += '&puid=p/' + item["puid"] + carousels_cgi[carousel]
        if item["sub"]:
            url_1 +=  '&subscription=' + item["sub"]
        all_users.append(scrap_recommendation(item["puid"], item["sub"], item["recom"], url_1))

    for item in uids:
        url_2 = 'http://entitysearch.yandex.net/entity/recommend?experiment=recommend_films&source=nmeta&format=json'
        url_2 += '&yandexuid=' + item["uid"] + carousels_cgi[carousel]
        if item["sub"]:
            url_2 +=  '&subscription=' + item["sub"]
        all_users.append(scrap_recommendation(item["uid"], item["sub"], item["recom"], url_2))

    # calc diff
    final = []
    for top in [10, 20, 30]:
        for item in all_users:
            final.append(calc_diff(item, top, carousel, date))

    cluster.write('//home/videolog/vika-pavlova/5232-renewability_metrics/results/' + carousel + '_' + window + '_' + date,
                  [Record(**dct) for dct in final]
                 )
    print "cluster_write"

def recs_combination(recs):
    for rec in recs:
        recs_list = list(product(
            (rec.top, '_total_'),
            (rec.carousel, '_total_'),
            (rec.user_subscription, '_total_')
        ))
        for item in recs_list:
            yield Record(top=item[0], carousel=item[1], user_subscription = item[2],
                         user = rec.user, intersection = rec.intersection,
                         empty_new_recomms = rec.empty_new_recomms,
                         empty_old_recomms = rec.empty_old_recomms, has_duplicates = rec.has_duplicates,
                         old_dups_count = rec.old_dups_count,
                         fielddate = rec.fielddate,
                        )

def prepare_for_stat(carousel, window, window_name, date):

    job = cluster.job()

    job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/' + carousel + '_' + window + '_' + date
             ).map(recs_combination
                  ).groupby('top', 'fielddate', 'carousel', 'user_subscription'
                       ).aggregate(intersection = na.mean('intersection'),
                                   empty_new_recomms_count = na.sum('empty_new_recomms'),
                                   empty_old_recomms_count = na.sum('empty_old_recomms'),
                                   old_dups_count = na.mean('lold_dups_count'),
                                   recomms_with_dups = na.sum('has_duplicates')
                                  ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_' + window_name
                                       )

    job.run()

def join_windows(carousel, date):

    job = cluster.job()
    """
    w1 = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w1'
                        ).project('top', 'fielddate', 'carousel', 'user_subscription',
                                  intersection_w1 = 'intersection',
                                  empty_new_recomms_count_w1 = 'empty_new_recomms_count',
                                  empty_old_recomms_count_w1 = 'empty_old_recomms_count',
                                  old_dups_count_w1 = 'old_dups_count',
                                  recomms_with_dups_w1 = 'recomms_with_dups'
                                )
    """
    w2 = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w2'
                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                          intersection_w2 = 'intersection',
                          empty_new_recomms_count_w2 = 'empty_new_recomms_count',
                          empty_old_recomms_count_w2 = 'empty_old_recomms_count',
                          old_dups_count_w2 = 'old_dups_count',
                          recomms_with_dups_w2 = 'recomms_with_dups'
                        )
    w4 = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w4'
                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                          intersection_w4 = 'intersection',
                          empty_new_recomms_count_w4 = 'empty_new_recomms_count',
                          empty_old_recomms_count_w4 = 'empty_old_recomms_count',
                          old_dups_count_w4 = 'old_dups_count',
                          recomms_with_dups_w4 = 'recomms_with_dups'
                        )
    w7 = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w7'
                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                          intersection_w7 = 'intersection',
                          empty_new_recomms_count_w7 = 'empty_new_recomms_count',
                          empty_old_recomms_count_w7 = 'empty_old_recomms_count',
                          old_dups_count_w7 = 'old_dups_count',
                          recomms_with_dups_w7 = 'recomms_with_dups'
                        )
    w14 = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w14'
                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                          intersection_w14 = 'intersection',
                          empty_new_recomms_count_w14 = 'empty_new_recomms_count',
                          empty_old_recomms_count_w14 = 'empty_old_recomms_count',
                          old_dups_count_w14 = 'old_dups_count',
                          recomms_with_dups_w14 = 'recomms_with_dups'
                        )
    w30 = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w30'
                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                          intersection_w30 = 'intersection',
                          empty_new_recomms_count_w30 = 'empty_new_recomms_count',
                          empty_old_recomms_count_w30 = 'empty_old_recomms_count',
                          old_dups_count_w30 = 'old_dups_count',
                          recomms_with_dups_w30 = 'recomms_with_dups'
                        )

    w1.join(w2, by = ('top', 'fielddate', 'carousel', 'user_subscription')
           ).join(w4, by = ('top', 'fielddate', 'carousel', 'user_subscription')
                 ).join(w7, by = ('top', 'fielddate', 'carousel', 'user_subscription')
                       ).join(w14, by = ('top', 'fielddate', 'carousel', 'user_subscription')
                             ).join(w30, by = ('top', 'fielddate', 'carousel', 'user_subscription')
                                   ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/' + carousel + '_results_' +  date)
    job.run()

def join_carousels(date):

    job = cluster.job()

    job.concat(
        job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/common_results_' + date),
        job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/films_results_' + date),
        job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/series_results_' + date),
        job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/anim_films_results_' + date),
        job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/anim_series_results_' + date)
            ).groupby('top', 'fielddate', 'carousel', 'user_subscription'
                    ).aggregate(intersection_w1 = na.mean("intersection_w1"),
                                empty_new_recomms_count_w1 = na.mean('empty_new_recomms_count_w1'),
                                empty_old_recomms_count_w1 = na.mean('empty_old_recomms_count_w1'),
                                old_dups_count_w1 = na.mean('old_dups_count_w1'),
                                recomms_with_dups_w1 = na.mean('recomms_with_dups_w1'),
                                intersection_w2 = na.mean("intersection_w2"),
                                empty_new_recomms_count_w2 = na.mean('empty_new_recomms_count_w2'),
                                empty_old_recomms_count_w2 = na.mean('empty_old_recomms_count_w2'),
                                old_dups_count_w2 = na.mean('old_dups_count_w2'),
                                recomms_with_dups_w2 = na.mean('recomms_with_dups_w2'),
                                intersection_w4 = na.mean("intersection_w4"),
                                empty_new_recomms_count_w4 = na.mean('empty_new_recomms_count_w4'),
                                empty_old_recomms_count_w4 = na.mean('empty_old_recomms_count_w4'),
                                old_dups_count_w4 = na.mean('old_dups_count_w4'),
                                recomms_with_dups_w4 = na.mean('recomms_with_dups_w4'),
                                intersection_w7 = na.mean("intersection_w7"),
                                empty_new_recomms_count_w7 = na.mean('empty_new_recomms_count_w7'),
                                empty_old_recomms_count_w7 = na.mean('empty_old_recomms_count_w7'),
                                old_dups_count_w7 = na.mean('old_dups_count_w7'),
                                recomms_with_dups_w7 = na.mean('recomms_with_dups_w7'),
                                intersection_w14 = na.mean("intersection_w14"),
                                empty_new_recomms_count_w14 = na.mean('empty_new_recomms_count_w14'),
                                empty_old_recomms_count_w14 = na.mean('empty_old_recomms_count_w14'),
                                old_dups_count_w14 = na.mean('old_dups_count_w14'),
                                recomms_with_dups_w14 = na.mean('recomms_with_dups_w14'),
                                intersection_w30 = na.mean("intersection_w30"),
                                empty_new_recomms_count_w30 = na.mean('empty_new_recomms_count_w30'),
                                empty_old_recomms_count_w30 = na.mean('empty_old_recomms_count_w30'),
                                old_dups_count_w30 = na.mean('old_dups_count_w30'),
                                recomms_with_dups_w30 = na.mean('recomms_with_dups_w30')
                                ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/total_' + date)
    job.run()


def put_to_stat(date):
    client = ns.StatfaceClient(
        proxy = 'upload.stat.yandex-team.ru',
        token = os.environ['STAT_TOKEN']
    )
    ns.StatfaceReport().path('Video.All/renewability_metrics_new') \
                       .scale('daily') \
                       .client(client) \
                       .remote_publish(proxy='hahn',
                                       table_path='//home/videolog/vika-pavlova/5232-renewability_metrics/results/total_' + date,
                                       async_mode=False,
                                       upload_config=False)

def main():

    parser = argparse.ArgumentParser()
    parser.add_argument('--start_date', type=str, required=True)
    parser.add_argument('--end_date', type=str, required=True)
    args = parser.parse_args()

    yt = cluster.driver.client
    def exists_and_not_empty(path, yt):
        return yt.exists(path) and not yt.is_empty(path)

    for date in pd.date_range(start=args.start_date, end=args.end_date):
        date_str = str(date)[:10]

        carousels = ['common', 'films', 'series', 'anim_films', 'anim_series']

        window_1 = str(datetime.datetime.strptime(date_str, '%Y-%m-%d') - datetime.timedelta(days = 1)).split(' ')[0]
        window_2 = str(datetime.datetime.strptime(date_str, '%Y-%m-%d') - datetime.timedelta(days = 2)).split(' ')[0]
        window_4 = str(datetime.datetime.strptime(date_str, '%Y-%m-%d') - datetime.timedelta(days = 4)).split(' ')[0]
        window_7 = str(datetime.datetime.strptime(date_str, '%Y-%m-%d') - datetime.timedelta(days = 7)).split(' ')[0]
        window_14 = str(datetime.datetime.strptime(date_str, '%Y-%m-%d') - datetime.timedelta(days = 14)).split(' ')[0]
        window_30 = str(datetime.datetime.strptime(date_str, '%Y-%m-%d') - datetime.timedelta(days = 30)).split(' ')[0]

        full_windows = {'w1': window_1, 'w2': window_2, 'w4': window_4, 'w7': window_7, 'w14': window_14, 'w30': window_30}
        window_list = {}
        available_windows = []

        for key, value in full_windows.iteritems():
            if exists_and_not_empty('//home/videolog/vika-pavlova/5232-renewability_metrics/recommendations/common_' + value, yt):
                window_list[value] = key
                available_windows.append(key)

        for carousel in carousels:
            print carousel
            for window, window_name in window_list.iteritems():
                print window
                find_recommendations(carousel, window, date_str)
                prepare_for_stat(carousel, window, window_name, date_str)

            if available_windows:

                job = cluster.job()
                job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w30'
                        ).project('top', 'fielddate', 'carousel', 'user_subscription',
                                intersection_w30 = 'intersection',
                                empty_new_recomms_count_w30 = 'empty_new_recomms_count',
                                empty_old_recomms_count_w30 = 'empty_old_recomms_count',
                                old_dups_count_w30 = 'old_dups_count',
                                recomms_with_dups_w30 = 'recomms_with_dups'
                                ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str
                                     )
                job.run()

            if len(available_windows) > 1:
                if 'w1' in available_windows:
                    job = cluster.job()
                    old = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str
                                     )
                    new = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w1'
                                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                                        intersection_w1 = 'intersection',
                                        empty_new_recomms_count_w1 = 'empty_new_recomms_count',
                                        empty_old_recomms_count_w1 = 'empty_old_recomms_count',
                                        old_dups_count_w1 = 'old_dups_count',
                                        recomms_with_dups_w1 = 'recomms_with_dups'
                                        )
                    old.join(new, by = ('top', 'fielddate', 'carousel', 'user_subscription')
                            ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str)
                    job.run()

                if 'w2' in available_windows:
                    job = cluster.job()
                    old = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str
                                     )
                    new = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w2'
                                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                                        intersection_w2 = 'intersection',
                                        empty_new_recomms_count_w2 = 'empty_new_recomms_count',
                                        empty_old_recomms_count_w2 = 'empty_old_recomms_count',
                                        old_dups_count_w2 = 'old_dups_count',
                                        recomms_with_dups_w2 = 'recomms_with_dups'
                                        )
                    old.join(new, by = ('top', 'fielddate', 'carousel', 'user_subscription')
                            ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str)
                    job.run()

                if 'w4' in available_windows:
                    job = cluster.job()
                    old = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str
                                     )
                    new = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w4'
                                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                                        intersection_w4 = 'intersection',
                                        empty_new_recomms_count_w4 = 'empty_new_recomms_count',
                                        empty_old_recomms_count_w4 = 'empty_old_recomms_count',
                                        old_dups_count_w4 = 'old_dups_count',
                                        recomms_with_dups_w4 = 'recomms_with_dups'
                                        )
                    old.join(new, by = ('top', 'fielddate', 'carousel', 'user_subscription')
                            ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str)
                    job.run()

                if 'w7' in available_windows:
                    job = cluster.job()
                    old = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str
                                     )
                    new = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w7'
                                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                                        intersection_w7 = 'intersection',
                                        empty_new_recomms_count_w7 = 'empty_new_recomms_count',
                                        empty_old_recomms_count_w7 = 'empty_old_recomms_count',
                                        old_dups_count_w7 = 'old_dups_count',
                                        recomms_with_dups_w7 = 'recomms_with_dups'
                                        )
                    old.join(new, by = ('top', 'fielddate', 'carousel', 'user_subscription')
                            ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str)
                    job.run()

                if 'w14' in available_windows:
                    job = cluster.job()
                    old = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str
                                     )
                    new = job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_w14'
                                ).project('top', 'fielddate', 'carousel', 'user_subscription',
                                        intersection_w14 = 'intersection',
                                        empty_new_recomms_count_w14 = 'empty_new_recomms_count',
                                        empty_old_recomms_count_w14 = 'empty_old_recomms_count',
                                        old_dups_count_w14 = 'old_dups_count',
                                        recomms_with_dups_w14 = 'recomms_with_dups'
                                        )
                    old.join(new, by = ('top', 'fielddate', 'carousel', 'user_subscription')
                            ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str)
                    job.run()

                job = cluster.job()
                job.table('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str
                         ).put('//home/videolog/vika-pavlova/5232-renewability_metrics/results/' + carousel + '_results_' +  date_str)
                job.run()

            #join_windows(carousel, date_str)

        join_carousels(date_str)
        put_to_stat(date_str)
        """
        for carousel in carousels:
            cluster.driver.remove('//home/videolog/vika-pavlova/5232-renewability_metrics/results/' + carousel + '_results_' +  date_str)
            cluster.driver.remove('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_tmp_' + date_str)
            print carousel
            for window, window_name in window_list.iteritems():
                cluster.driver.remove('//home/videolog/vika-pavlova/5232-renewability_metrics/results/final_' + carousel + '_' + window_name)

        del_date = window_2
        del_window_2 = str(datetime.datetime.strptime(del_date, '%Y-%m-%d') - datetime.timedelta(days = 2)).split(' ')[0]
        del_window_4 = str(datetime.datetime.strptime(del_date, '%Y-%m-%d') - datetime.timedelta(days = 4)).split(' ')[0]
        del_window_7 = str(datetime.datetime.strptime(del_date, '%Y-%m-%d') - datetime.timedelta(days = 7)).split(' ')[0]
        del_window_14 = str(datetime.datetime.strptime(del_date, '%Y-%m-%d') - datetime.timedelta(days = 14)).split(' ')[0]
        del_window_30 = str(datetime.datetime.strptime(del_date, '%Y-%m-%d') - datetime.timedelta(days = 30)).split(' ')[0]
        del_window_list = [window_1, window_2, window_4, window_7, window_14, window_30]

        for carousel in carousels:
            print carousel
            for window in del_window_list:
                if exists_and_not_empty('//home/videolog/vika-pavlova/5232-renewability_metrics/results/' + carousel + '_' + window + '_' + del_date, yt):
                    cluster.driver.remove('//home/videolog/vika-pavlova/5232-renewability_metrics/results/' + carousel + '_' + window + '_' + del_date)
        """


if __name__ == '__main__':
    main()
