# -*- coding: utf-8 -*-

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf
import argparse
import nile
import datetime, time
import json, re
import urllib, urlparse
import math,cgi
import pandas as pd
from itertools import product
import sys
import os
import copy
import random


cluster = clusters.yt.Hahn(pool='vika-pavlova'
      ).env(templates=dict(job_root='//home/videolog/vika-pavlova/video_recommendations/offline_recomms/offline_recomms'
                          ),
            yt_spec_defaults=dict(pool_trees=["physical"],
                                  tentative_pool_trees=["cloud"]),
            parallel_operations_limit=10
           )


def prepare_recoms(groups):
    for key, recs in groups:
        components = []
        for rec in recs:

            component = {
                "componentUrl":{
                    "pageUrl": rec['url'],
                    "viewUrl": urlparse.urlparse(rec['url']).netloc
                },
                 "thumbadd": {
                     "urls": [rec['image']]
                 },
                "text.title": rec['title'],
                "text.snippet": rec['description'],
                "onto_id": rec["ontoid"]
            }
            components.append(component)
        yield Record(puid = key['puid'], components = components)


def serp_recoms_prepare(date):

    job = cluster.job()


    tolokers = job.table('//home/videolog/vika-pavlova/video_recommendations/current_tolokers'
                        ).project("workerId",
                                  puid = ne.custom(lambda x: str(x), "puid")
                                 )

    #serp film
    film = job.table('//home/dict/danilchenko/toloka_offline_recommendations/serp/film/latest'
                   ).project('title', 'description', "ranking_score", 'image', 'url', "ontoid",
                             puid = ne.custom(lambda x: x.replace('p/', ''), 'id'),
                             neg_ranking_score = ne.custom(lambda x: (-1)*x, 'ranking_score')
                            )
    top_film = film.groupby('puid'
                           ).top(10, by = "ranking_score"
                                )
    parsed_film = top_film.groupby('puid'
                                 ).sort('neg_ranking_score'
                                       ).reduce(prepare_recoms
                                                )
    parsed_film.join(tolokers, by = 'puid'
                    ).put('//home/videolog/vika-pavlova/video_recommendations/offline_recomms/recoms/serp_film/' + date
                         )
    parsed_film.join(tolokers, by = 'puid'
                    ).put('//home/videolog/vika-pavlova/video_recommendations/offline_recomms/cold_recoms/serp_film/' + date
                         )

    #serp series
    series = job.table('//home/dict/danilchenko/toloka_offline_recommendations/serp/series/latest'
                      ).project('title', 'description', "ranking_score", 'image', 'url', "ontoid",
                                puid = ne.custom(lambda x: x.replace('p/', ''), 'id'),
                                neg_ranking_score = ne.custom(lambda x: (-1)*x, 'ranking_score')
                               )
    top_series = series.groupby('puid'
                           ).top(10, by = "ranking_score"
                                )
    parsed_series = top_series.groupby('puid'
                                      ).sort('neg_ranking_score'
                                            ).reduce(prepare_recoms
                                                     )
    parsed_series.join(tolokers, by = 'puid'
                      ).put('//home/videolog/vika-pavlova/video_recommendations/offline_recomms/recoms/serp_series/' + date
                           )
    parsed_series.join(tolokers, by = 'puid'
                      ).put('//home/videolog/vika-pavlova/video_recommendations/offline_recomms/cold_recoms/serp_series/' + date
                           )
    """
    #serp mixed
    mixed = job.table('//home/dict/danilchenko/toloka_offline_recommendations/mixed/latest'
                      ).project('title', 'description', "ranking_score", 'image', 'url', "ontoid",
                                puid = ne.custom(lambda x: x.replace('p/', ''), 'id'),
                                neg_ranking_score = ne.custom(lambda x: (-1)*x, 'ranking_score')
                               )
    top_mixed = mixed.groupby('puid'
                           ).top(10, by = "ranking_score"
                                )

    parsed_mixed = top_mixed.groupby('puid'
                                      ).sort('neg_ranking_score'
                                            ).reduce(prepare_recoms
                                                     )
    parsed_mixed.join(tolokers, by = 'puid'
                      ).put('//home/videolog/vika-pavlova/video_recommendations/offline_recomms/recoms/serp_mixed/' + date
                           )

    """

    #serp anim film
    anim_film = job.table('//home/dict/danilchenko/toloka_offline_recommendations/serp/anim_film/latest'
                      ).project('title', 'description', "ranking_score", 'image', 'url', "ontoid",
                                puid = ne.custom(lambda x: x.replace('p/', ''), 'id'),
                                neg_ranking_score = ne.custom(lambda x: (-1)*x, 'ranking_score')
                               )
    top_anim_film = anim_film.groupby('puid'
                           ).top(10, by = "ranking_score"
                                )

    parsed_anim_film = top_anim_film.groupby('puid'
                                      ).sort('neg_ranking_score'
                                            ).reduce(prepare_recoms
                                                     )
    parsed_anim_film.join(tolokers, by = 'puid'
                      ).put('//home/videolog/vika-pavlova/video_recommendations/offline_recomms/recoms/serp_anim_film/' + date
                           )
    parsed_anim_film.join(tolokers, by = 'puid'
                      ).put('//home/videolog/vika-pavlova/video_recommendations/offline_recomms/cold_recoms/serp_anim_film/' + date
                           )

    #serp anim series
    anim_series = job.table('//home/dict/danilchenko/toloka_offline_recommendations/serp/anim_series/latest'
                      ).project('title', 'description', "ranking_score", 'image', 'url', "ontoid",
                                puid = ne.custom(lambda x: x.replace('p/', ''), 'id'),
                                neg_ranking_score = ne.custom(lambda x: (-1)*x, 'ranking_score')
                               )
    top_anim_series = anim_series.groupby('puid'
                           ).top(10, by = "ranking_score"
                                )

    parsed_anim_series = top_anim_series.groupby('puid'
                                      ).sort('neg_ranking_score'
                                            ).reduce(prepare_recoms
                                                     )
    parsed_anim_series.join(tolokers, by = 'puid'
                      ).put('//home/videolog/vika-pavlova/video_recommendations/offline_recomms/recoms/serp_anim_series/' + date
                           )
    parsed_anim_series.join(tolokers, by = 'puid'
                      ).put('//home/videolog/vika-pavlova/video_recommendations/offline_recomms/cold_recoms/serp_anim_series/' + date
                           )

    job.run()


def main():

    parser = argparse.ArgumentParser()
    parser.add_argument('--date', type=str, required=True)
    parser.add_argument('--carousel_type', type=str, required=True)
    args = parser.parse_args()

    serp_recoms_prepare(args.date)


if __name__ == '__main__':
    main()
