class views_lack:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        no_views = 0

        results = metric_params.results[:self.depth]

        for res in results:

            if res.scales['video_relevance'] not in ['RELEVANT_PLUS', 'RELEVANT_MINUS']:
                continue

            views = res.scales.get('json.serpData', {}).get('views', 'No_info')

            if views == 'No_info':
                no_views += 1

        return no_views
