class CountAds:
    def __init__(self, depth=10, host="frontend.vh.yandex"):
        self.depth = depth
        self.host = host.split('__')

    # metric value for one serp
    def value(self, metric_params):
    
        has_add = 0
        all = 0.0
        for index, result in enumerate(metric_params.results[:self.depth]):
            url = result.scales["componentUrl"]["pageUrl"]
            all += 1
            if any(x in url for x in self.host):
                has_add += 1
                # break

        return has_add/all if all else 0.0
