class VideoWizardShare:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        has_wizard = 0

        for res in results:
            componentInfo = res.scales.get("componentInfo",{})
            if componentInfo.get("type", '') == 2 and componentInfo.get("wizardType", '') in [19, 108]:
                has_wizard = 1

        return has_wizard

class VideoWizardSPShare:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        has_wiz_sp = 0

        for res in results:
            componentInfo = res.scales.get("componentInfo",{})
            if componentInfo.get("type", '') == 1 and componentInfo.get("wizardType", '') == 36:
                has_wiz_sp = 1

        return has_wiz_sp

class VideoWizardAnyShare:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        has_wizard = 0

        for res in results:
            componentInfo = res.scales.get("componentInfo",{})
            if componentInfo.get("type", '') == 2 and componentInfo.get("wizardType", '') in [19, 108]:
                has_wizard = 1
            elif componentInfo.get("type", '') == 1 and componentInfo.get("wizardType", '') == 36:
                has_wizard = 1

        return has_wizard
