class WizardDedicatedTime:

    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):
        has_dedicated_time = 0

        results = metric_params.results[:self.depth]

        for res in results:
            dedicated_time = res.scales.get("json.video_with_dedicated_time",{})
            if dedicated_time.get('start_time', ''):
                has_dedicated_time = 1

        return has_dedicated_time


class VideoDedicatedTime:

    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):
        has_dedicated_time = 0

        results = metric_params.results[:self.depth]
        for res in results:
            if res.scales.get("text.fragment_start_time", ""):
                has_dedicated_time = 1

        return has_dedicated_time
