class InsideKeypoints:
    def __init__(self, depth=30):
        self.depth = depth

    def value_by_position(self, position_metric_params):
        res = position_metric_params.result

        keypoints = res.get_scale("json.insights_keypoints", [])

        if keypoints:
            return 1
        return 0

    def aggregate_by_position(self, agg_metric_params):
        metric_values = agg_metric_params.pos_metric_values
        marks = [x.value for x in metric_values[:self.depth] if x.value is not None]

        if len(marks) == 0:
            return 0

        return 1.0 * sum(marks) / self.depth

class HasInsideKeypoints:
    def __init__(self, depth=30):
        self.depth = depth

    def value_by_position(self, position_metric_params):
        res = position_metric_params.result

        keypoints = res.get_scale("json.insights_keypoints", [])

        if keypoints:
            return 1
        return 0

    def aggregate_by_position(self, agg_metric_params):
        metric_values = agg_metric_params.pos_metric_values
        marks = [x.value for x in metric_values[:self.depth] if x.value is not None]

        if len(marks) == 0:
            return 0

        return int(sum(marks) > 0)
