import math
import re
import json

class PirateHosts:
    def __init__(self, depth=5):
        self.depth = depth


    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        params = json.loads(metric_params.serp_data.get("serp_query_param.custom_param", "{}"))

        need_piracy_fine = False
        is_film = int(params.get("is_film", "0"))
        is_serial = int(params.get("is_serial", "0"))

        if is_film or is_serial:
            need_piracy_fine = True

        if need_piracy_fine:

            total = 0
            pirates_count = 0

            for res in results:
                total += 1
                piracy = res.scales.get("player_stivenson_type")
                if piracy == "pirate":
                    pirates_count += 1

            return pirates_count / total

        else:
            return -1


class SemiPirateHosts:
    def __init__(self, depth=5):
        self.depth = depth


    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        params = json.loads(metric_params.serp_data.get("serp_query_param.custom_param", "{}"))

        need_piracy_fine = False
        is_film = int(params.get("is_film", "0"))
        is_serial = int(params.get("is_serial", "0"))

        if is_film or is_serial:
            need_piracy_fine = True

        if need_piracy_fine:

            total = 0
            semi_pirates_count = 0

            for res in results:

                total += 1
                piracy = res.scales.get("player_stivenson_type")
                player_id = res.scales.get("text.playerId")

                if piracy == "semi_pirate" and player_id not in ["ok", "vk", "mailru", "mailru_new"]:
                    semi_pirates_count += 1

            return semi_pirates_count / total

        else:
            return -1


class BoostValue:
    def __init__(self, depth=5,
                 boost_value=0.3,
                 fragment_hosts_weight=0.99,
                 social_net_hosts_weight=0.5,
                 pirate_hosts_weight=1.0,
                 freshness_always_fine=0.5,
                 freshness_tmp_fine=0):
        self.depth = depth

        self.fragment_hosts_weight = fragment_hosts_weight
        self.social_net_hosts_weight = social_net_hosts_weight
        self.pirate_hosts_weight = pirate_hosts_weight
        self.default_fragment_min_duration = 3 * 60
        self.default_fragment_max_duration = 5 * 60
        self.default_film_min_duration = 60 * 60
        self.default_film_max_duration = 3 * 60 * 60
        self.default_series_min_duration = 5 * 60
        self.default_series_max_duration = 60 * 60

        self.freshness_always_fine = freshness_always_fine
        self.freshness_tmp_fine = freshness_tmp_fine

    def value(self, metric_params):


        results = metric_params.results[:self.depth]

        params = json.loads(metric_params.serp_data.get("serp_query_param.custom_param", "{}"))

        need_piracy_fine = False
        is_film = int(params.get("is_film", "0"))
        is_serial = int(params.get("is_serial", "0"))

        if is_film or is_serial:
            need_piracy_fine = True
            if metric_params.serp_data.get('judgements.video_object_duration') and metric_params.serp_data['judgements.video_object_duration']['name'] != 'unknown':
                object_type = metric_params.serp_data['judgements.video_object_type']['name']
                object_duration = metric_params.serp_data['judgements.video_object_duration']['name']
                min_duration = float(object_duration) * 0.8
                max_duration = float(object_duration) * 1.2
            else:
                if is_film:
                    min_duration = self.default_film_min_duration
                    max_duration = self.default_film_max_duration
                else:
                    min_duration = self.default_series_min_duration
                    max_duration = self.default_series_max_duration

        if need_piracy_fine:

            total  = 0
            boost_sum = 0

            for res in results:

                total += 1
                boost = 1.0

                player_id = res.scales.get("text.playerId")
                piracy = res.scales.get("player_stivenson_type")

                if not res.scales.get("text.videoDuration"):
                    duration = 0
                else:
                    convert_to_seconds=[1, 60, 3600]
                    duration = sum(int(x)*y for x, y in zip(res.scales.get("text.videoDuration").split(':')[::-1],
                                                            convert_to_seconds))

                is_trailer = False
                is_content = False
                is_fragment = False

                if res.scales.get("trailer_toloka", "OTHER") == "TRAILER":
                    is_trailer = True
                elif (duration >= min_duration and duration <= max_duration) or duration > max_duration:
                    is_content = True
                else:
                    is_fragment = True

                if is_content:
                    if piracy == "semi_pirate" and player_id not in ["ok", "vk", "mailru", "mailru_new"]:
                        boost = self.social_net_hosts_weight
                    elif piracy == "pirate":
                        boost = self.pirate_hosts_weight
                elif is_fragment:
                    boost = self.fragment_hosts_weight


                boost_sum += boost
            return boost_sum / total

        else:
            return -1

