class SerpHasVideoWizard:
    def __init__(self, depth=1):
        self.depth = depth

    def value(self, metric_params):
        return float(metric_params.serp_data["tags.hasVideoWizard"])


class HasTranslationsWithWizard:
    def __init__(self, depth=1):
        self.depth = depth

    def value(self, metric_params):
        return float(metric_params.serp_data["tags.hasVideoWizard"] and len(metric_params.results) > 0)

class NoTranslationsWithWizard:
    def __init__(self, depth=1):
        self.depth = depth

    def value(self, metric_params):
        return float(metric_params.serp_data["tags.hasVideoWizard"] and len(metric_params.results) == 0)
