import math
import re
import json

class SvodVDP:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):
        results = metric_params.results[:self.depth]

        count_404 = 0
        total = 0

        for res in results:
            is_est = res.scales.get("tags.isEST", False)
            is_svod = res.scales.get("tags.isSVOD", False)
            is_tvod = res.scales.get("tags.isTVOD", False)

            if res.scales['video_relevance']:
                total += 1
                if res.scales['video_relevance'] in ['SOFT_404', '_404'] and (is_est or is_svod or is_tvod):
                    count_404 += 1

        if total:
            return count_404 * 100.0 / total
