import math
import re
import json
import datetime
import time

class VideoCwidth:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        good = 0

        for res in results:
            total += 1
            if res.scales.get("json.serpData", {}).get("cwidth") and int(res.scales.get("json.serpData", {}).get("cwidth")) > 1:
                good += 1

        if total:
            return 1.0 * good / total
        else:
            return -1


class PreviewHeight:
    def __init__(self,
                 depth=5,
                 height_threshold = 480
                ):
        self.depth = depth
        self.height_threshold = height_threshold

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        good = 0

        for res in results:
            total += 1
            preview = res.scales.get("json.videoPreviews", [])
            if preview and preview[0].get("height") and int(preview[0].get("height")) >= self.height_threshold:
                good += 1

        if total:
            return 1.0 * good / total
        else:
            return -1


class PreviewIshighres:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        good = 0

        for res in results:
            total += 1
            preview = res.scales.get("json.videoPreviews", [])
            if preview:
                for item in preview:
                    if item.get("ishighres", False) == True:
                        good += 1

        if total:
            return 1.0 * good / total
        else:
            return -1
