
class VideoTiktokShare(object):
    def __init__(self, depth):
        self.depth = depth

    def value_by_position(self, position_metric_params):

        res = position_metric_params.result

        if res.pos > self.depth:
            return None
        serpData = res.get_scale("json.serpData", None)

        if serpData is None or "VisibleURL" not in serpData:
            return None
        
        if serpData["VisibleURL"].find("tiktok") != -1:
            return 1.0
        return 0.0
    
    def aggregate_by_position(self, agg_metric_params):
        metric_values = agg_metric_params.pos_metric_values
        marks = [x.value for x in metric_values[:self.depth] if x.value is not None]

        if len(marks) == 0:
            return None

        return 1.0 * sum(marks) / len(marks)
        
class VideoVerticalShare(object):
    def __init__(self, depth):
        self.depth = depth
    
    def is_vertical(self, cratio):
        return cratio < 1
    
    def value_by_position(self, position_metric_params):

        res = position_metric_params.result

        if res.pos > self.depth:
            return None
        serpData = res.get_scale("json.serpData", None)
        if serpData is None or "cratio" not in serpData:
            return None
        
        if self.is_vertical(float(serpData["cratio"])):
            return 1.0
        return 0.0
    
    def aggregate_by_position(self, agg_metric_params):
        metric_values = agg_metric_params.pos_metric_values
        marks = [x.value for x in metric_values[:self.depth] if x.value is not None]

        if len(marks) == 0:
            return None

        return 1.0 * sum(marks) / len(marks)
        
class VideoVerticalComponentShareByAmount(VideoVerticalShare):
    def __init__(self, depth, min_amount, max_amount):
        super(VideoVerticalComponentShareByAmount, self).__init__(depth)
        self.min_amount = min_amount
        self.max_amount = max_amount
        
    def aggregate_by_position(self, agg_metric_params):
        metric_values = agg_metric_params.pos_metric_values
        marks = [x.value for x in metric_values[:self.depth] if x.value is not None]
        
        if len(marks) == 0:
            return None
            
        if self.min_amount <= sum(marks) <= self.max_amount:
            return 1.0
        else:
            return 0.0
