class FragmentStartAccuracy:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        total = 0
        good = 0

        results = metric_params.results[:self.depth]

        for res in results:
            if res.scales.get('fragment_start_accuracy', "no_fragment") != "no_fragment":
                total += 1
                if res.scales.get('fragment_start_accuracy', "no_fragment") == 'yes':
                    good += 1
        if total:
            return good * 1.0 /total
        else:
            return -1

class FirstFragmentStartAccuracy:
    def __init__(self, depth=5):
        self.depth = depth

    def value(self, metric_params):

        total = 0
        good = 0

        results = metric_params.results[:self.depth]

        for res in results:
            if res.scales.get('fragment_start_accuracy', "no_fragment") != "no_fragment" and total == 0:
                total += 1
                if res.scales.get('fragment_start_accuracy', "no_fragment") == 'yes':
                    good += 1
        if total:
            return good * 1.0 /total
        else:
            return -1
