from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf
import argparse
import nile
import datetime
import uatraits, json, re
import urllib, urlparse
import math,cgi
import pandas as pd
from itertools import product
import sys
import os


def redir_log_parse(date):

    cluster = clusters.yt.Hahn(pool='vika-pavlova'
    ).env(templates=dict(job_root='home/videolog/vika-pavlova/one_parse_from_redir_log'
                        ),
          yt_spec_defaults=dict(pool_trees=["physical"],
                                #tentative_pool_trees=["cloud"]),
                                use_default_tentative_pool_trees = True),
          parallel_operations_limit=10
         )

    job = cluster.job()

    redir = job.table('logs/redir-log/1d/' + date)

    raw = redir.qb2(log = 'redir-log',
                    fields = ['path','yandexuid','date',
                              se.log_field('content_id'),
                              se.log_field('source'),
                              se.log_field('from_block'),
                              se.log_field('stream_block'),
                              se.log_field('licence'),
                              se.log_field('svod'),
                              se.log_field('reqid'),
                              se.log_field('channel_id'),
                              se.custom('hb', lambda x: 1 if 'heartbeat' in x else 0,'path'),
                              se.custom('adStart', lambda x: 1 if 'adStart' in str(x) else 0, 'path'),
                              se.custom('error', lambda x: 1 if 'error' in x else 0,'path')
                             ],
                    filters = [sf.defined('yandexuid', 'content_id', 'source'),
                               sf.contains('path', 'player-events.'),
                               sf.or_(sf.contains('source', 'morda'),
                                      sf.contains('source', 'serp'),
                                      sf.contains('source', 'videohub'),
                                      sf.contains('source', 'streamhandler'),
                                      sf.contains('source', 'efir'),
                                      sf.equals('source', 'special'),
                                      sf.equals('source', 'yanews'),
                                      sf.equals('source', 'ya-sport'),
                                      sf.equals('source', 'yanewstragic'),
                                      sf.equals('source', 'yavideo')
                                     )
                              ],
                    mode = 'yamr_lines'
                   ).sort('yandexuid'
                         ).put('$job_root/raw_' + date)

    job.run()


def main():

  parser = argparse.ArgumentParser()
  parser.add_argument('--start_date', type=str, required=True)
  parser.add_argument('--end_date', type=str, required=True)
  args = parser.parse_args()

  for date in pd.date_range(start=args.start_date, end=args.end_date):
      date_str = str(date)[:10]
      redir_log_parse(date_str)


if __name__ == '__main__':
  main()
