class DocOntoCompleteness:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        has_ontoid = 0

        for res in results:
            total += 1

            ontoid = res.scales.get("text.videoOntoId", '')

            if ontoid:
                has_ontoid += 1

        if total != 0:
            return has_ontoid * 100.0 / total
        else:
            return -1


class DocOntoAccuracy:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        correct = 0

        for res in results:
            total += 1

            relevance = res.scales.get("onto_doc_relevance", '')
            if relevance in ["CORRECT", "CORRECT_EMPTY_OBJECT"]:
                correct += 1

        if total != 0:
            return correct * 100.0 / total
        else:
            return -1


class WrongEmptyObject:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        wrong_empty = 0

        for res in results:
            total += 1

            relevance = res.scales.get("judgements.onto_doc_relevance", '')
            if relevance == "WRONG_EMPTY_OBJECT":
                wrong_empty += 1

        if total != 0:
            return wrong_empty * 100.0 / total
        else:
            return -1


class NotCorrect:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        not_correct = 0

        for res in results:
            total += 1

            relevance = res.scales.get("judgements.onto_doc_relevance", '')
            if relevance == "NOT_CORRECT":
                not_correct += 1

        if total != 0:
            return not_correct * 100.0 / total
        else:
            return -1


class Correct:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        correct = 0

        for res in results:
            total += 1

            relevance = res.scales.get("judgements.onto_doc_relevance", '')
            if relevance in ["CORRECT"]:
                correct += 1

        if total != 0:
            return correct * 100.0 / total
        else:
            return -1


class CorrectEmptyObject:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        total = 0
        correct = 0

        for res in results:
            total += 1

            relevance = res.scales.get("judgements.onto_doc_relevance", '')
            if relevance in ["CORRECT_EMPTY_OBJECT"]:
                correct += 1

        if total != 0:
            return correct * 100.0 / total
        else:
            return -1
