class QueryOntoCompleteness:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        if 'text.object_id' in metric_params.serp_data and metric_params.serp_data['text.object_id']:
            return 1
        else:
            return 0


class QueryOntoAccuracy:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        onto_title_correctness = metric_params.serp_data['judgements.onto_title_correctness']['name']

        if onto_title_correctness in ["CORRECT", "CORRECT_EMPTY_OBJECT"]:
            return 1
        else:
            return 0


class QueryOntoCorrect:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        onto_title_correctness = metric_params.serp_data['judgements.onto_title_correctness']['name']

        if onto_title_correctness == "CORRECT":
            return 1
        else:
            return 0

class QueryOntoNotCorrect:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        onto_title_correctness = metric_params.serp_data['judgements.onto_title_correctness']['name']

        if onto_title_correctness == "NOT_CORRECT":
            return 1
        else:
            return 0

class QueryOntoCorrectEmpty:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        onto_title_correctness = metric_params.serp_data['judgements.onto_title_correctness']['name']

        if onto_title_correctness == "CORRECT_EMPTY_OBJECT":
            return 1
        else:
            return 0


class QueryOntoWrongEmpty:

    def __init__(self, depth = 5):

        self.depth = depth

    def value(self, metric_params):

        onto_title_correctness = metric_params.serp_data['judgements.onto_title_correctness']['name']

        if onto_title_correctness == "WRONG_EMPTY_OBJECT":
            return 1
        else:
            return 0
