# -*- coding: utf-8 -*-

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf
import argparse
import nile
import datetime, time
import uatraits, json, re
import urllib, urlparse
import math,cgi
import pandas as pd
from itertools import product
import sys
import os

import requests
import json
# import http.client
import httplib

cluster = clusters.yt.Hahn(pool='vika-pavlova'
                          ).env(templates=dict(job_root='//home/videolog/vika-pavlova/4672-p1_vh'
                                              ),
                                yt_spec_defaults=dict(pool_trees=["physical"],
                                                      use_default_tentative_pool_trees = True),
                                parallel_operations_limit=10
                                )

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--oauth_token', type=str, required=True)
    args = parser.parse_args()

    baskets_dict = {"video_vh.films_avod_desktop": "380678", "video_vh.films_svod_desktop": "380795",
                    "video_vh.films_tvod_desktop": "380796", "video_vh.films_other_desktop": "380797",
                    "video_vh.films_avod_touch": "380798", "video_vh.films_svod_touch": "380799",
                    "video_vh.films_tvod_touch": "380800", "video_vh.films_other_touch": "380801",
                    "video_vh.series_avod_desktop": "380820", "video_vh.series_svod_desktop": "380821",
                    "video_vh.series_tvod_desktop": "380822", "video_vh.series_other_desktop": "380823",
                    "video_vh.series_avod_touch": "380824", "video_vh.series_svod_touch": "380825",
                    "video_vh.series_tvod_touch": "380826", "video_vh.series_other_touch": "380827",
                    "video_vh.seasons_avod_desktop": "380828", "video_vh.seasons_svod_desktop": "380829",
                    "video_vh.seasons_tvod_desktop": "380849", "video_vh.seasons_other_desktop": "380850",
                    "video_vh.seasons_avod_touch": "380851", "video_vh.seasons_svod_touch": "380852",
                    "video_vh.seasons_tvod_touch": "380853", "video_vh.seasons_other_touch": "380854",
                    "video_vh.music_desktop": "380855", "video_vh.music_touch": "380857",
                    "video_vh.youtube_desktop": "380858", "video_vh.youtube_touch": "380859",
                    "video_vh.ya_news_desktop": "380860", "video_vh.ya_news_touch": "380861",
                    "video_vh.ugc_desktop": "380862", "video_vh.ugc_touch": "380864",
                    "video_vh.zen_desktop": "382303", "video_vh.zen_touch": "382304"}

    yt = cluster.driver.client

    tables = list(yt.search(root = '//home/videolog/vika-pavlova/4672-p1_vh', node_type = 'table'))

    for table in tables:
        dict_key = 'video_vh.' + table.replace('//home/videolog/vika-pavlova/4672-p1_vh/basket_', '')
        if dict_key in baskets_dict:
            dict_value = str(baskets_dict[dict_key])

            basket = []
            if cluster.driver.read(table):
                for rec in cluster.driver.read(table):
                    basket.append({
                        'country': rec['country'],
                        "device": rec["device"],
                        "labels": rec["labels"],
                        "params": rec["params"],
                        "regionId": rec["regionId"],
                        "text": rec["text"]
                    })
                print basket[0]
                my_data = {
                     "queries": basket,
                     "type": "RAW"
                }
                url = 'http://metrics.yandex-team.ru/api-qgaas/basket/%s/query-generator?comment=from_apii' %(dict_value)
                r = requests.put(url = url,
                     headers = {'Content-Type': 'application/json',
                                'charset': 'UTF-8',
                                "Authorization" : "OAuth " + args.oauth_token},
                     data = json.dumps(my_data).encode('utf-8')
                    )
                print r

if __name__ == '__main__':
    main()
