# -*- coding: utf-8 -*-

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf
import argparse
import nile
import datetime, time
import uatraits, json, re
import urllib, urlparse
import math,cgi
import pandas as pd
from itertools import product
import sys
import os


cluster = clusters.yt.Hahn(pool='vika-pavlova'
                          ).env(templates=dict(job_root='//home/videolog/vika-pavlova/4672-p1_vh'
                                              ),
                                yt_spec_defaults=dict(pool_trees=["physical"],
                                                      use_default_tentative_pool_trees = True),
                                parallel_operations_limit=10
                                )

def find_vh_lvt2amount(table):
    vh_lvt = 0
    count =  0
    for rec in cluster.driver.read(table):
        count += 1
        vh_lvt += rec['lvt']

    return vh_lvt * 1. /count

class metrics_format():
    def __init__(self, basket_type, metrics_device, vh_lvt2amount):
        self.basket_type = basket_type
        self.metrics_device = metrics_device
        self.vh_lvt2amount = vh_lvt2amount

    def __call__(self, recs):
        for rec in recs:
            text = rec['query'] if self.basket_type == 'films' else rec["Name"]
            regionId = 225
            country = "RU"
            device = self.metrics_device
            video_id = "UUID" if (self.basket_type == 'zen' or not rec['ContentGroupID']) else 'ContentGroupID'
            params = [
                {"name": "content_type", "value": self.basket_type},
                {"name": "license", "value": rec['license'] if rec['license'] else 0},
                {"name": "urls", "value": "https://frontend.vh.yandex.ru/player/" + str(rec[video_id])},
                {"name": "lvt", "value": rec['lvt']},
                {"name": "lvt_weight", "value": rec['lvt'] * 1. / self.vh_lvt2amount},
                {"name": "ontoid", "value": rec["onto_id"] if rec["onto_id"] else 0},
                {"name": "is_fresh", "value": rec["is_fresh"] if "is_fresh" in rec and rec["is_fresh"] else 0},
                {"name": "query_type", "value": 'title'}
            ]
            labels = [self.basket_type, rec['place']]
            if rec['license']:
                labels.append(rec['license'].lower())
            if "is_fresh" in rec and rec["is_fresh"]:
                labels.append('fresh')
            if self.metrics_device == "DESKTOP":
                labels.append('desktop')
            else:
                labels.append('touch')

            yield Record(text = text, regionId = regionId, country = country, device = device,
                         params = params, labels = labels
                        )

class metrics_season_format():
    def __init__(self, basket_type, metrics_device, vh_lvt2amount):
        self.basket_type = basket_type
        self.metrics_device = metrics_device
        self.vh_lvt2amount = vh_lvt2amount

    def __call__(self, recs):
        for rec in recs:
            text = rec['season_title']
            regionId = 225
            country = "RU"
            device = self.metrics_device
            params = [
                {"name": "content_type", "value": self.basket_type},
                {"name": "license", "value": rec['license'] if rec['license'] else 0},
                {"name": "urls1", "value": rec['urls1']},
                {"name": "urls2", "value": rec['urls2']},
                {"name": "urls3", "value": rec['urls3']},
                {"name": "urls4", "value": rec['urls4']},
                {"name": "urls5", "value": rec['urls5']},
                {"name": "lvt", "value": rec['lvt']},
                {"name": "lvt_weight", "value": rec['lvt'] * 1. / self.vh_lvt2amount},
                {"name": "ontoid", "value": rec["onto_id"] if rec["onto_id"] else 0},
                {"name": "is_fresh", "value": rec["is_fresh"] if "is_fresh" in rec and rec["is_fresh"] else 0},
                {"name": "query_type", "value": 'title'}
            ]
            labels = [self.basket_type]
            if rec['license']:
                labels.append(rec['license'].lower())
            if "is_fresh" in rec and rec["is_fresh"]:
                labels.append('fresh')
            if self.metrics_device == "DESKTOP":
                labels.append('desktop')
            else:
                labels.append('touch')

            yield Record(text = text, regionId = regionId, country = country, device = device,
                         params = params, labels = labels
                        )

def gather_seasons_basket(basket_type, license, device):

    vh_lvt2amount = find_vh_lvt2amount('//home/videolog/vika-pavlova/4672-p1_vh/' + basket_type + '_' + device)
    metrics_device = "DESKTOP" if (device == 'desktop') else "ANDROID"

    job = cluster.job()

    raw = job.table('//home/videolog/vika-pavlova/4672-p1_vh/' + basket_type + '_' + license + '_' + device)

    top = raw.top(2000, by = 'tvt'
                 ).project(ne.all(),
                           place = ne.const('top')
                          )
    other = raw.join(top, by = ('season_title', "onto_id"), type = 'left_only'
                    ).random(2000
                            ).project(ne.all(),
                                      place = ne.const('random')
                                     )
    job.concat(top, other
              ).map(metrics_season_format(basket_type, metrics_device, vh_lvt2amount)
                   ).put('$job_root/basket_' + basket_type + '_' + license + '_' + device)

    job.run()

def gather_films_basket(basket_type, license, device):
    vh_lvt2amount = find_vh_lvt2amount('//home/videolog/vika-pavlova/4672-p1_vh/' + basket_type + '_' + device)
    metrics_device = "DESKTOP" if (device == 'desktop') else "ANDROID"

    job = cluster.job()
    raw = job.table('//home/videolog/vika-pavlova/4672-p1_vh/' + basket_type + '_' + license + '_' + device)
    top = raw.top(1000, by = 'tvt'
                ).project(ne.all(),
                            place = ne.const('top')
                        )
    other = raw.join(top, by = "UUID", type = 'left_only'
                    ).random(1000
                            ).project(ne.all(),
                                    place = ne.const('random')
                                    )
    job.concat(top, other
            ).map(metrics_format(basket_type, metrics_device, vh_lvt2amount)
                    ).put('$job_root/basket_' + basket_type + '_' + license + '_' + device)

    job.run()

def gather_other_basket(basket_type, device):
    vh_lvt2amount = find_vh_lvt2amount('//home/videolog/vika-pavlova/4672-p1_vh/' + basket_type + '_' + device)
    metrics_device = "DESKTOP" if (device == 'desktop') else "ANDROID"

    job = cluster.job()
    raw = job.table('//home/videolog/vika-pavlova/4672-p1_vh/' + basket_type + '_' + device)
    top = raw.top(2000, by = 'tvt'
                ).project(ne.all(),
                            place = ne.const('top')
                        )
    other = raw.join(top, by = "UUID", type = 'left_only'
                    ).random(2000
                            ).project(ne.all(),
                                    place = ne.const('random')
                                    )
    job.concat(top, other
            ).map(metrics_format(basket_type, metrics_device, vh_lvt2amount)
                    ).put('$job_root/basket_' + basket_type + '_' + device)

    job.run()

def reduce_seasons_url(groups):

    for key, recs in groups:
        urls1 = ""
        urls2 = ""
        urls3 = ""
        urls4 = ""
        urls5 = ""
        release_date = ""
        for rec in recs:
            if  (str(rec["Name"]).decode('utf-8')).endswith(u'Cерия 1') or u'Cерия 1 ' in str(rec["Name"]).decode('utf-8'):
                urls1 = "https://frontend.vh.yandex.ru/player/" + str(rec['ContentGroupID'])
                release_date = rec['release_date']
            elif (str(rec["Name"]).decode('utf-8')).endswith(u'Серия 2') or u'Серия 2 ' in str(rec["Name"]).decode('utf-8'):
                urls2 = "https://frontend.vh.yandex.ru/player/" + str(rec['ContentGroupID'])
            elif (str(rec["Name"]).decode('utf-8')).endswith(u'Серия 3') or u'Серия 3 ' in str(rec["Name"]).decode('utf-8'):
                urls3 = "https://frontend.vh.yandex.ru/player/" + str(rec['ContentGroupID'])
            elif (str(rec["Name"]).decode('utf-8')).endswith(u'Серия 4') or u'Серия 4 ' in str(rec["Name"]).decode('utf-8'):
                urls4 = "https://frontend.vh.yandex.ru/player/" + str(rec['ContentGroupID'])
            elif (str(rec["Name"]).decode('utf-8')).endswith(u'Серия 5') or u'Серия 5 ' in str(rec["Name"]).decode('utf-8'):
                urls5 = "https://frontend.vh.yandex.ru/player/" + str(rec['ContentGroupID'])

        yield Record(season_title = key['season_title'], computed_program = key['computed_program'],
                     onto_id = key['onto_id'], tvt = key['tvt'], lvt = key['lvt'],
                     license = key['license'],
                     urls1 = urls1, urls2 = urls2, urls3 = urls3, urls4 = urls4, urls5 = urls5,
                     release_date = release_date
                    )
def change_title(title):
    tmp = title.split('-')[:-1]
    ind = -1
    for i in range(len(tmp)):
        if u'Серия' in str(tmp[i]).decode('utf-8'):
            ind = i
    if ind >-1:
        return ('-'.join(tmp[:ind])).strip()
    else:
        return ('-'.join(tmp)).strip()

def parse_sessions(start_date, end_date):
    now = time.time()
    job = cluster.job()

    sessions = job.table('//cubes/video-strm/{' + start_date +'..' + end_date + '}/sessions'
                        ).project("UUID", "view_time", "device_type",
                                    lvt = ne.custom(lambda x: math.log(x, math.e) if x else 0, "view_time")
                                )
    iron_branch = job.table('//home/videolog/strm_meta/iron_branch/concat')
    onto = job.table('//home/videolog/vika-pavlova/2844-diversity_metrics/parse_oo')

    aggr = sessions.groupby("UUID", "device_type"
                            ).aggregate(reqs = na.count(),
                                        tvt = na.sum("view_time"),
                                        lvt = na.sum('lvt')
                                    ).put('$job_root/aggr')

    joined = aggr.join(iron_branch, by_left = 'UUID', by_right = "JoinKey"
                    ).put('$job_root/joined_1'
                            ).filter(sf.custom(lambda x: x=="[]" or 'ya-video' in x, "TMP_OvsServiceFlags")
                                    )

    joined_desktop = joined.filter(sf.equals("device_type", "desktop")
                                ).put('$job_root/joined_desktop')
    joined_touch = joined.filter(sf.equals("device_type", "phone")
                                ).put('$job_root/joined_touch')

    #music
    joined_desktop.filter(sf.equals("computed_channel", "# MUSIC CLIPS")
                        ).project(ne.all(),
                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                ).sort('view_time'
                                        ).put('$job_root/music_desktop')
    joined_touch.filter(sf.equals("computed_channel", "# MUSIC CLIPS")
                        ).project(ne.all(),
                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                ).sort('view_time'
                                        ).put('$job_root/music_touch')
    #youtube
    joined_desktop.filter(sf.custom(lambda x: x and x.startswith("Youtube."), "computed_channel"
                                    )
                        ).project(ne.all(),
                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                ).sort('view_time'
                                        ).put('$job_root/youtube_desktop')
    joined_touch.filter(sf.custom(lambda x: x and x.startswith("Youtube."), "computed_channel"
                                    )
                        ).project(ne.all(),
                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                ).sort('view_time'
                                        ).put('$job_root/youtube_touch')
    #ya-news
    joined_desktop.filter(sf.equals("computed_channel", 'ya-news')
                        ).project(ne.all(),
                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                ).sort('view_time'
                                        ).put('$job_root/ya_news_desktop')
    joined_touch.filter(sf.equals("computed_channel", 'ya-news')
                        ).project(ne.all(),
                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                ).sort('view_time'
                                        ).put('$job_root/ya_news_touch')
    #ugs
    joined_desktop.filter(sf.custom(lambda x: x and x.startswith("UGC."), "computed_channel"
                                    )
                        ).project(ne.all(),
                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                ).sort('view_time'
                                        ).put('$job_root/ugc_desktop')
    joined_desktop.filter(sf.custom(lambda x: x and x.startswith("UGC."), "computed_channel"
                                    )
                        ).project(ne.all(),
                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                ).sort('view_time'
                                        ).put('$job_root/ugc_touch')
    #channels
    """
    joined_desktop.filter(sf.equals("channel_type", 'yatv')
                        ).sort('view_time'
                                ).put('$job_root/yatv_desktop')
    joined_desktop.filter(sf.equals("channel_type", 'yatv')
                        ).sort('view_time'
                                ).put('$job_root/yatv_desktop')
    """
    #films
    films_desktop = joined_desktop.filter(sf.custom(lambda x: x and x[0] == "Film/Film", 'onto_type')
                                        ).join(onto, by = "onto_id"
                                                ).project(ne.all(),
                                                        is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                                        ).put('$job_root/films_desktop')
    films_desktop.filter(sf.equals("license", "Avod")
                        ).sort('view_time'
                            ).put('$job_root/films_avod_desktop')
    films_desktop.filter(sf.equals("license", "Svod")
                        ).sort('view_time'
                            ).put('$job_root/films_svod_desktop')
    films_desktop.filter(sf.equals("license", "Tvod_Est")
                        ).sort('view_time'
                            ).put('$job_root/films_tvod_desktop')
    films_desktop.filter(sf.custom(lambda x: x not in ["Tvod_Est", "Avod", "Svod"], "license")
                        ).sort('view_time'
                            ).put('$job_root/films_other_desktop')

    films_touch = joined_touch.filter(sf.custom(lambda x: x and x[0] == "Film/Film", 'onto_type')
                                    ).join(onto, by = "onto_id"
                                            ).project(ne.all(),
                                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                                    ).put('$job_root/films_touch')
    films_touch.filter(sf.equals("license", "Avod")
                    ).sort('view_time'
                            ).put('$job_root/films_avod_touch')
    films_touch.filter(sf.equals("license", "Svod")
                    ).sort('view_time'
                            ).put('$job_root/films_svod_touch')
    films_touch.filter(sf.equals("license", "Tvod_Est")
                    ).sort('view_time'
                            ).put('$job_root/films_tvod_touch')
    films_touch.filter(sf.custom(lambda x: x not in ["Tvod_Est", "Avod", "Svod"], "license")
                    ).sort('view_time'
                            ).put('$job_root/films_other_touch')

    #series
    series_desktop = joined_desktop.filter(sf.custom(lambda x, y: x and (x[0] == "Film/Series@on" or
                                                                (x[0] == ['Film/Season@on'] and y == "ott")),
                                            'onto_type', "computed_channel")
                                        ).project(ne.all(),
                                                    is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                                    ).put('$job_root/series_desktop')
    series_desktop.filter(sf.equals("license", "Avod")
                        ).sort('view_time'
                                ).put('$job_root/series_avod_desktop')
    series_desktop.filter(sf.equals("license", "Svod")
                        ).sort('view_time'
                                ).put('$job_root/series_svod_desktop')
    series_desktop.filter(sf.equals("license", "Tvod_Est")
                        ).sort('view_time'
                                ).put('$job_root/series_tvod_desktop')
    series_desktop.filter(sf.custom(lambda x: x not in ["Tvod_Est", "Avod", "Svod"], "license")
                        ).sort('view_time'
                                ).put('$job_root/series_other_desktop')

    series_touch = joined_touch.filter(sf.custom(lambda x, y: x and (x[0] == "Film/Series@on" or
                                                                (x[0] == ['Film/Season@on'] and y == "ott")),
                                            'onto_type', "computed_channel")
                                    ).project(ne.all(),
                                                is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                                ).put('$job_root/series_touch')
    series_touch.filter(sf.equals("license", "Avod")
                        ).sort('view_time'
                                ).put('$job_root/series_avod_touch')
    series_touch.filter(sf.equals("license", "Svod")
                        ).sort('view_time'
                                ).put('$job_root/series_svod_touch')
    series_touch.filter(sf.equals("license", "Tvod_Est")
                        ).sort('view_time'
                                ).put('$job_root/series_tvod_touch')
    series_touch.filter(sf.custom(lambda x: x not in ["Tvod_Est", "Avod", "Svod"], "license")
                        ).sort('view_time'
                                ).put('$job_root/series_other_touch')
    #seasons
    seasons_desktop = series_desktop.project(ne.all(),
                                            season_title = ne.custom(lambda x: change_title(x), 'Name')
                                            ).groupby('season_title', "computed_program", "onto_id", 'license'
                                                    ).aggregate(tvt = na.sum('tvt'),
                                                                lvt = na.sum('lvt'),
                                                                name = na.any('Name')
                                                                )

    joined_desktop_seasons = seasons_desktop.join(iron_branch, by =("computed_program", "onto_id")
                                        ).project(ne.all(),
                                                    new_season_title = ne.custom(lambda x: change_title(x), 'Name')
                                                )

    seasons_desktop_final = joined_desktop_seasons.filter(sf.custom(lambda x, y: x and x == y, 'season_title', 'new_season_title'
                                                            )
                                                ).groupby('season_title', "computed_program", "onto_id", 'tvt', 'lvt', 'license'
                                                        ).reduce(reduce_seasons_url
                                                                ).put('$job_root/seasons_desktop')
    seasons_desktop_final.filter(sf.equals("license", "Avod")
                                ).project(ne.all(),
                                        is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                        ).sort('tvt').put('$job_root/seasons_avod_desktop')
    seasons_desktop_final.filter(sf.equals("license", "Svod")
                                ).project(ne.all(),
                                        is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                        ).sort('tvt').put('$job_root/seasons_svod_desktop')
    seasons_desktop_final.filter(sf.equals("license", "Tvod_Est")
                                ).project(ne.all(),
                                        is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                        ).sort('tvt').put('$job_root/seasons_tvod_desktop')
    seasons_desktop_final.filter(sf.custom(lambda x: x not in ["Tvod_Est", "Avod", "Svod"], "license")
                                ).project(ne.all(),
                                        is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                        ).sort('tvt').put('$job_root/seasons_other_desktop')

    seasons_touch = series_touch.project(ne.all(),
                                            season_title = ne.custom(lambda x: change_title(x), 'Name')
                                            ).groupby('season_title', "computed_program", "onto_id", 'license'
                                                    ).aggregate(tvt = na.sum('tvt'),
                                                                lvt = na.sum('lvt'),
                                                                name = na.any('Name')
                                                                )

    joined_touch_seasons = seasons_touch.join(iron_branch, by =("computed_program", "onto_id")
                                        ).project(ne.all(),
                                                    new_season_title = ne.custom(lambda x: change_title(x), 'Name')
                                                )

    seasons_touch_final = joined_touch_seasons.filter(sf.custom(lambda x, y: x and x == y, 'season_title', 'new_season_title'
                                                            )
                                                ).groupby('season_title', "computed_program", "onto_id", 'tvt', 'lvt', 'license'
                                                        ).reduce(reduce_seasons_url
                                                                ).put('$job_root/seasons_touch')
    seasons_touch_final.filter(sf.equals("license", "Avod")
                                ).project(ne.all(),
                                        is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                        ).sort('tvt').put('$job_root/seasons_avod_touch')
    seasons_touch_final.filter(sf.equals("license", "Svod")
                                ).project(ne.all(),
                                        is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                        ).sort('tvt').put('$job_root/seasons_svod_touch')
    seasons_touch_final.filter(sf.equals("license", "Tvod_Est")
                                ).project(ne.all(),
                                        is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                        ).sort('tvt').put('$job_root/seasons_tvod_touch')
    seasons_touch_final.filter(sf.custom(lambda x: x not in ["Tvod_Est", "Avod", "Svod"], "license")
                                ).project(ne.all(),
                                        is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                                        ).sort('tvt').put('$job_root/seasons_other_touch')

    #zen
    joined_desktop.filter(sf.custom(lambda x, y: x == "zen_cinema" or y == "zen", 'ugc_service', 'computed_channel')
                    ).project(ne.all(),
                                is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                            ).sort('view_time'
                                    ).put('$job_root/zen_desktop')
    joined_touch.filter(sf.custom(lambda x, y: x == "zen_cinema" or y == "zen", 'ugc_service', 'computed_channel')
                    ).project(ne.all(),
                                is_fresh = ne.custom(lambda x: int(now-int(x) < 7*24*3600) if x else 0, 'release_date')
                            ).sort('view_time'
                                    ).put('$job_root/zen_touch')

    job.run()

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--start_date', type=str, required=True)
    parser.add_argument('--end_date', type=str, required=True)
    args = parser.parse_args()

    parse_sessions(args.start_date, args.end_date)

    gather_films_basket('films', 'avod', 'desktop')
    gather_films_basket('films', 'svod', 'desktop')
    gather_films_basket('films', 'tvod', 'desktop')
    gather_films_basket('films', 'other', 'desktop')
    gather_films_basket('films', 'avod', 'touch')
    gather_films_basket('films', 'svod', 'touch')
    gather_films_basket('films', 'tvod', 'touch')
    gather_films_basket('films', 'other', 'touch')

    gather_films_basket('series', 'avod', 'desktop')
    gather_films_basket('series', 'svod', 'desktop')
    gather_films_basket('series', 'tvod', 'desktop')
    gather_films_basket('series', 'other', 'desktop')
    gather_films_basket('series', 'avod', 'touch')
    gather_films_basket('series', 'svod', 'touch')
    gather_films_basket('series', 'tvod', 'touch')
    gather_films_basket('series', 'other', 'touch')

    gather_seasons_basket('seasons', 'avod', 'desktop')
    gather_seasons_basket('seasons', 'svod', 'desktop')
    gather_seasons_basket('seasons', 'tvod', 'desktop')
    gather_seasons_basket('seasons', 'other', 'desktop')
    gather_seasons_basket('seasons', 'avod', 'touch')
    gather_seasons_basket('seasons', 'svod', 'touch')
    gather_seasons_basket('seasons', 'tvod', 'touch')
    gather_seasons_basket('seasons', 'other', 'touch')

    gather_other_basket('music', 'desktop')
    gather_other_basket('music', 'touch')

    gather_other_basket('youtube', 'desktop')
    gather_other_basket('youtube', 'touch')

    gather_other_basket('ya_news', 'desktop')
    gather_other_basket('ya_news', 'touch')

    gather_other_basket('zen', 'desktop')
    gather_other_basket('zen', 'touch')

    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/aggr')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/joined_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/joined_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/music_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/music_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/youtube_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/youtube_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/ya_news_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/ya_news_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/ugc_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/ugc_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/zen_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/zen_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_touch')
    #cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_desktop')
    #cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_avod_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_avod_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_svod_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_svod_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_tvod_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_tvod_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_other_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/films_other_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_avod_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_avod_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_svod_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_svod_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_tvod_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_tvod_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_other_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/series_other_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/seasons_avod_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/seasons_svod_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/seasons_svod_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/seasons_tvod_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/seasons_tvod_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/seasons_other_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/seasons_other_touch')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/seasons_desktop')
    cluster.driver.remove('//home/videolog/vika-pavlova/4672-p1_vh/seasons_touch')

if __name__ == '__main__':
    main()
