import json

class BloggersTopVideo:
    def __init__(self, depth=3):
        self.depth = depth
    # metric value for one serp
    def value(self, metric_params):

        total = 0
        correct_urls = 0

        fresh_urls = json.loads(metric_params.serp_data.get("serp_query_param.urls", {}))
        metric_depth = min(len(fresh_urls), self.depth)

        pos = 1
        for result in metric_params.results[:metric_depth]:

            url = result.scales["componentUrl"]["pageUrl"]
            fresh_url = fresh_urls["top_" + str(pos)]['url']

            if fresh_url:
                total += 1
                right_url = fresh_url.split('//', 1)[1]
                if url.split('//', 1)[1] == right_url:
                    correct_urls += 1

            pos += 1
        if total:
            return correct_urls * 1. / total
        else:
            return 0
