from metrics.offline import SerpMetricParamsForAPI

class CorrectVH:
    def __init__(self, depth=10):
        self.depth = depth
    # metric value for one serp
    def value(self, metric_params):
        """
        :type metric_params: SerpMetricParamsForAPI
        :rtype: float
        """

        if metric_params.serp_data.get("serp_query_param.content_type", '') != 'seasons':
            return -1

        total = 0
        correct_urls = 0

        pos = 1

        for result in metric_params.results[:self.depth]:
            param = "serp_query_param.urls" + str(pos)
            if metric_params.serp_data.get(param, ''):
                total += 1
                vh_url = metric_params.serp_data.get(param, '').split('//', 1)[1]
                url = result.scales["componentUrl"]["pageUrl"]
                if url.split('//', 1)[1] == vh_url:
                    correct_urls += 1
            pos += 1
        if total:
            return correct_urls * 1. / total
        else:
            return 0
