class PornoLeakage:

    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        bad = 0
        total = 0

        for res in results:
            if 'porno_top_relevance' in res.scales:
                total += 1
                if res.scales['porno_top_relevance'] == 'BAD':
                    bad += 1

        if total:
            return bad * 100.0 / total

class ErrorPorno:

    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        error = 0
        total = 0

        for res in results:
            if 'porno_top_relevance' in res.scales:
                total += 1
                if res.scales['porno_top_relevance'] == '404':
                    error += 1

        if total:
            return error * 100.0 / total
