import math
import urlparse

class ProximaQuality:
    def __init__(self, depth=5,
                 video_quality_desktop_weight=1, video_quality_norm_desktop_weight=0.5,
                 kernel_desktop_weight=1,
                 popularity_desktop_weight=1,
                 video_quality_touch_weight=1, video_quality_norm_touch_weight=0.5,
                 kernel_touch_weight=1,
                 popularity_touch_weight=1):

        self.depth = depth

        self.video_quality_desktop_weight = video_quality_desktop_weight
        self.video_quality_norm_desktop_weight = video_quality_norm_desktop_weight
        self.kernel_desktop_weight = kernel_desktop_weight
        self.popularity_desktop_weight = popularity_desktop_weight

        self.video_quality_touch_weight = video_quality_touch_weight
        self.video_quality_norm_touch_weight = video_quality_norm_touch_weight
        self.kernel_touch_weight = kernel_touch_weight
        self.popularity_touch_weight = popularity_touch_weight

    def value(self, metric_params):

        BOOST_VALUE = 0.3

        def num_value(label, middle_mark_weight):

            v = {'OK': 1.0, 'NORM': middle_mark_weight, 'BAD': 0.0, '_404': 0.0}

            return v[label]

        def coef(rel):

            v = {'RELEVANT_PLUS': BOOST_VALUE,
                 'RELEVANT_MINUS': BOOST_VALUE,
                 'IRRELEVANT': 0.0
                 }

            return v.get(rel, 0.0)

        def get_factor_names(serp_data):

            host = urlparse.urlparse(serp_data["headers"]["cleanUrl"]).netloc

            if "yandex" in host:
                return "video_quality"
            elif "google" in host:
                return "video_quality_google"
            else:
                return "unknown_system"

        def get_factors_combination(res, metric_params):

            video_quality_name = get_factor_names(metric_params.serp_data)

            if video_quality_name == "unknown_system":
                raise Exception
                return 0

            IS_DESKTOP = 0
            is_desktop = metric_params.query_device == IS_DESKTOP

            if is_desktop:
                video_quality_weight = self.video_quality_desktop_weight
                kernel_weight = self.kernel_desktop_weight
                popularity_weight = self.popularity_desktop_weight
            else:
                video_quality_weight = self.video_quality_touch_weight
                kernel_weight = self.kernel_touch_weight
                popularity_weight = self.popularity_touch_weight

            if is_desktop:
                video_quality = num_value(res.scales.get(video_quality_name, '_404'), self.video_quality_norm_desktop_weight)
            else:
                video_quality = num_value(res.scales.get(video_quality_name, '_404'), self.video_quality_norm_touch_weight)

            my_clickadd = video_quality * video_quality_weight

            my_clickadd = float(my_clickadd) / (video_quality_weight + kernel_weight * 0.5 + popularity_weight)

            return my_clickadd

        results = metric_params.results[:self.depth]

        max_dcg = (1.0 + BOOST_VALUE) * sum([1.0 / math.log(2 + pos) for pos in range(self.depth)])
        dcg = 0

        for res in results:
            pos_index = res.pos
            assert (pos_index >= 1)

            relevance = res.scales.get("video_relevance", '_404')
            rel_value = coef(relevance) * get_factors_combination(res, metric_params)

            dcg += rel_value / math.log(1 + pos_index)

        return dcg / max_dcg
