import math

class ProximaRelevance:
    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        REL_MINUS_WEIGHT = 0.7
        BOOST_VALUE = 0.3

        def num_value(label, middle_mark_weight):

            v = {'RELEVANT_PLUS': 1.0, 'RELEVANT_MINUS': middle_mark_weight, 'IRRELEVANT': 0.0, \
                     'SOFT_404': 0.0, '_404': 0.0, 'VIRUS' : 0.0}

            return v[label]

        results = metric_params.results[:self.depth]

        max_dcg = (1.0 + BOOST_VALUE) * sum([1.0 / math.log(2 + pos) for pos in range(self.depth)])
        dcg = 0

        for res in results:
            pos_index = res.pos
            assert (pos_index >= 1)

            relevance = res.scales.get("video_relevance", '_404')
            rel_value = num_value(relevance, REL_MINUS_WEIGHT)

            dcg += rel_value / math.log(1 + pos_index)

        return dcg / max_dcg
