import math
import re
import json
import urlparse

class VideoProxima:
    def __init__(self, depth=5,
                 video_quality_norm_weight=0.5,
                 video_quality_not_porno_weight=0,
                 kernel_not_porno_weight=0,
                 popularity_not_porno_weight=0,
                 player_quality_not_porno_weight=0,
                 binary_relevance_not_porno_weight=0,
                 video_quality_porno_weight=0,
                 kernel_porno_weight=0,
                 popularity_porno_weight=0,
                 player_quality_porno_weight=0,
                 binary_relevance_porno_weight=0,
                 kernel_multiplier=0.5,
                 with_dups_fine=False,
                 boost_value=0.3):
        self.depth = depth
        self.video_quality_norm_weight = video_quality_norm_weight

        self.video_quality_not_porno_weight = video_quality_not_porno_weight
        self.kernel_not_porno_weight = kernel_not_porno_weight
        self.popularity_not_porno_weight = popularity_not_porno_weight
        self.player_quality_not_porno_weight = player_quality_not_porno_weight
        self.binary_relevance_not_porno_weight = binary_relevance_not_porno_weight

        self.video_quality_porno_weight = video_quality_porno_weight
        self.kernel_porno_weight = kernel_porno_weight
        self.popularity_porno_weight = popularity_porno_weight
        self.player_quality_porno_weight = player_quality_porno_weight
        self.binary_relevance_porno_weight = binary_relevance_porno_weight

        self.kernel_multiplier = kernel_multiplier
        self.with_dups_fine = with_dups_fine
        self.boost_value=boost_value

    def value(self, metric_params):

        BOOST_VALUE = self.boost_value

        def num_value(param_name, label, middle_mark_weight):
            if param_name == 'rel':
                v = {'RELEVANT_PLUS': 1.0, 'RELEVANT_MINUS': middle_mark_weight, 'IRRELEVANT': 0.0, \
                     'SOFT_404': 0.0, '_404': 0.0, 'VIRUS' : 0.0}
            elif param_name == 'quality':
                v = {'OK': 1.0, 'NORM': middle_mark_weight, 'BAD': 0.0, '_404': 0.0}
            return v[label]

        def coef(rel):
            v = {'RELEVANT_PLUS': BOOST_VALUE,
                 'RELEVANT_MINUS': BOOST_VALUE,
                 'IRRELEVANT': 0.0
                 }
            return v.get(rel, 0.0)

        def get_factor_names(serp_data):
            host = urlparse.urlparse(serp_data["headers"]["cleanUrl"]).netloc
            if "yandex" in host:
                return "video_quality", True
            elif "google" in host:
                return "video_quality_google", False
            else:
                return "unknown_system", None

        def get_factors_combination(res, metric_params):
            video_quality_name, is_yandex_serp = get_factor_names(metric_params.serp_data)

            if video_quality_name == "unknown_system":
                raise Exception
                return 0

            is_porno = int(metric_params.serp_data.get("query_param.is_porno", "0"))
            print is_porno

            if is_porno:
                video_quality_weight = self.video_quality_porno_weight
                kernel_weight = self.kernel_porno_weight
                popularity_weight = self.popularity_porno_weight
                player_quality_weight = self.player_quality_porno_weight
                binary_relevance_weight = self.binary_relevance_porno_weight
            else:
                video_quality_weight = self.video_quality_not_porno_weight
                kernel_weight = self.kernel_not_porno_weight
                popularity_weight = self.popularity_not_porno_weight
                player_quality_weight = self.player_quality_not_porno_weight
                binary_relevance_weight = self.binary_relevance_not_porno_weight

            video_quality = num_value('quality', res.scales.get(video_quality_name, '_404'), self.video_quality_norm_weight)

            my_clickadd = video_quality * video_quality_weight

            my_clickadd = float(my_clickadd) / (video_quality_weight + kernel_weight * self.kernel_multiplier + popularity_weight + player_quality_weight + binary_relevance_weight)

            return my_clickadd

        results = metric_params.results[:self.depth]

        max_dcg = (1.0 + BOOST_VALUE) * sum([1.0 / math.log(2 + pos) for pos in range(self.depth)])

        need_duplicates = int(metric_params.serp_data.get("query_param.need_duplicates", "0"))
        print need_duplicates
        dups_fines = {}

        dcg = 0

        for res in results:
            pos_index = res.pos
            assert (pos_index >= 1)

            dups_fine = 1
            if need_duplicates and self.with_dups_fine:
                dup_pos = int(res.scales.get("video_dups", "-1"))
                if dup_pos > 0:
                    dups_fine = dups_fines.get(dup_pos, 1) * 0.5
                    dups_fines[dup_pos] = dups_fine

            relevance = res.scales.get("video_relevance", '_404')
            rel_value = coef(relevance) * get_factors_combination(res, metric_params)

            dcg += dups_fine * rel_value / math.log(1 + pos_index)

        return dcg / max_dcg
