import math
import re
import json

class VideoProxima:
    def __init__(self, depth=5,
                 video_quality_not_porno_weight=0,
                 kernel_not_porno_weight=0,
                 popularity_not_porno_weight=0,
                 player_quality_not_porno_weight=0,
                 binary_relevance_not_porno_weight=0,
                 video_quality_porno_weight=0,
                 kernel_porno_weight=0,
                 popularity_porno_weight=0,
                 player_quality_porno_weight=0,
                 binary_relevance_porno_weight=0,
                 kernel_multiplier=0.5,
                 with_dups_fine=False,
                 boost_value=0.3):
        self.depth = depth

        self.video_quality_not_porno_weight = video_quality_not_porno_weight
        self.kernel_not_porno_weight = kernel_not_porno_weight
        self.popularity_not_porno_weight = popularity_not_porno_weight
        self.player_quality_not_porno_weight = player_quality_not_porno_weight
        self.binary_relevance_not_porno_weight = binary_relevance_not_porno_weight

        self.video_quality_porno_weight = video_quality_porno_weight
        self.kernel_porno_weight = kernel_porno_weight
        self.popularity_porno_weight = popularity_porno_weight
        self.player_quality_porno_weight = player_quality_porno_weight
        self.binary_relevance_porno_weight = binary_relevance_porno_weight

        self.kernel_multiplier = kernel_multiplier
        self.with_dups_fine = with_dups_fine
        self.boost_value=boost_value

    def value(self, metric_params):

        REL_MINUS_WEIGHT = 0.7
        BOOST_VALUE = self.boost_value

        def num_value(param_name, label, middle_mark_weight):
            if param_name == 'rel':
                v = {'RELEVANT_PLUS': 1.0, 'RELEVANT_MINUS': middle_mark_weight, 'IRRELEVANT': 0.0, \
                     'SOFT_404': 0.0, '_404': 0.0, 'VIRUS' : 0.0}
            elif param_name == 'quality':
                v = {'OK': 1.0, 'NORM': middle_mark_weight, 'BAD': 0.0, '_404': 0.0}
            return v[label]

        results = metric_params.results[:self.depth]

        max_dcg = (1.0 + BOOST_VALUE) * sum([1.0 / math.log(2 + pos) for pos in range(self.depth)])

        need_duplicates = int(metric_params.serp_data.get("query_param.need_duplicates", "0"))
        print need_duplicates
        dups_fines = {}

        dcg = 0

        for res in results:
            pos_index = res.pos
            assert (pos_index >= 1)

            dups_fine = 1
            if need_duplicates and self.with_dups_fine:
                dup_pos = int(res.scales.get("video_dups", "-1"))
                if dup_pos > 0:
                    dups_fine = dups_fines.get(dup_pos, 1) * 0.5
                    dups_fines[dup_pos] = dups_fine

            relevance = res.scales.get("video_relevance", '_404')
            rel_value = num_value('rel', relevance, REL_MINUS_WEIGHT)

            dcg += dups_fine * rel_value / math.log(1 + pos_index)

        return dcg / max_dcg
