class content_types_metric:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        types_count = 0

        films_count = 0
        series_count = 0
        bloggers_count = 0
        others_count = 0

        for res in results:
            if not res.scales['content_type']:
                continue
            if res.scales['content_type'] == 'film':
                films_count += 1
            elif res.scales['content_type'] == 'series':
                series_count += 1
            elif res.scales['content_type'] == 'blogger':
                bloggers_count += 1
            else:
                others_count += 1

        if films_count > 0:
            types_count += 1
        if series_count > 0:
            types_count += 1
        if bloggers_count > 0:
            types_count += 1
        if others_count > 0:
            types_count += 1

        # metric - average count of different types in recommendations
        if self.flag == 0:
            return types_count
        # metric - share of documents having only 1 type of content in recommendations
        elif self.flag == 1:
            if types_count == 1:
                return 100
            else:
                return 0
        # metric - share of documents having 2 types of content in recommendations
        elif self.flag == 2:
            if types_count == 2:
                return 100
            else:
                return 0
        # metric - share of documents having 3 types of content in recommendations
        elif self.flag == 3:
            if types_count == 3:
                return 100
            else:
                return 0
        # metric - share of documents having 4 types of content in recommendations
        elif self.flag == 4:
            if types_count == 4:
                return 100
            else:
                return 0


class genres_count_metric:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        genres_set = set()

        for res in results:
            if not res.scales['genre']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                genres_set.add(res.scales['genre'])
            else:
                return -1

        if  len(genres_set) != 0:
            return len(genres_set)
        else:
            return -1


class genres_p_50:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]
        genres_p = -1.0

        for res in results:
            if not res.scales['genres_p_50']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                genres_p = res.scales['genres_p_50']
                break

        if genres_p != -1:
            return float(genres_p)
        else:
            return -1


class genres_p_90:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]
        genres_p = -1.0

        for res in results:
            if not res.scales['genres_p_90']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                genres_p = res.scales['genres_p_90']
                break

        return float(genres_p)


class countries_count_metric:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        countries_set = set()

        for res in results:
            if not res.scales['country']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                countries_set.add(res.scales['country'])
            else:
                return -1

        if  len(countries_set) != 0:
            return len(countries_set)
        else:
            return -1


class countries_p_50:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]
        countries_p = -1.0

        for res in results:
            if not res.scales['countries_p_50']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                countries_p = res.scales['countries_p_50']
                break

        return float(countries_p)


class countries_p_90:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]
        countries_p = 'none'

        for res in results:
            if not res.scales['countries_p_90']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                countries_p = res.scales['countries_p_90']
                break

        return float(countries_p)


class years_count_metric:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        years_set = set()

        for res in results:
            if not res.scales['content_year']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                years_set.add(res.scales['content_year'])
            else:
                return -1

        if  len(years_set) != 0:
            return len(years_set)
        else:
            return -1


class years_p_50:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        years_p = -1.0

        for res in results:
            if not res.scales['years_p_50']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                years_p = res.scales['years_p_50']
                break

        return float(years_p)


class years_p_90:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        years_p = -1.0

        for res in results:
            if not res.scales['years_p_90']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                years_p = res.scales['years_p_90']
                break

        return float(years_p)


class decade_count_metric:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        decades_set = set()

        for res in results:
            if not res.scales['decade']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                decades_set.add(res.scales['decade'])
            else:
                return -1

        if  len(decades_set) != 0:
            return len(decades_set)
        else:
            return -1


class decades_p_50:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        decades_p = -1.0

        for res in results:
            if not res.scales['decades_p_50']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                decades_p = res.scales['decades_p_50']
                break

        return float(decades_p)


class decades_p_90:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        decades_p = -1.0

        for res in results:
            if not res.scales['decades_p_90']:
                continue
            if res.scales['content_type'] == 'film' or res.scales['content_type'] == 'series':
                decades_p = res.scales['decades_p_90']
                break

        return float(decades_p)


class channels_count_metric:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        channels_set = set()

        for res in results:
            if not res.scales['channel']:
                continue
            if res.scales['content_type'] == 'blogger':
                channels_set.add(res.scales['channel'])
            else:
                return -1

        if  len(channels_set) != 0:
            return len(channels_set)
        else:
            return -1


class channels_p_50:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        channels_p = -1.0

        for res in results:
            if not res.scales['channels_p_50']:
                continue
            if res.scales['content_type'] == 'blogger':
                channels_p = res.scales['channels_p_50']
                break

        return float(channels_p)


class channels_p_90:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        channels_p = -1.0

        for res in results:
            if not res.scales['channels_p_90']:
                continue
            if res.scales['content_type'] == 'blogger':
                channels_p = res.scales['channels_p_90']
                break

        return float(channels_p)


class blogger_theme_count_metric:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        themes_set = set()

        for res in results:
            if not res.scales['blogger_theme']:
                continue
            if res.scales['content_type'] == 'blogger':
                themes_set.add(res.scales['blogger_theme'])
            else:
                return -1

        if  len(themes_set) != 0:
            return len(themes_set)
        else:
            return -1


class blogger_themes_p_50:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        blogger_themes_p = -1.0

        for res in results:
            if not res.scales['blogger_themes_p_50']:
                continue
            if res.scales['content_type'] == 'blogger':
                blogger_themes_p = res.scales['blogger_themes_p_50']
                break

        return float(blogger_themes_p)


class blogger_themes_p_90:

    def __init__(self, depth=1, flag=0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        blogger_themes_p = -1.0

        for res in results:
            if not res.scales['blogger_themes_p_90']:
                continue
            if res.scales['content_type'] == 'blogger':
                blogger_themes_p = res.scales['blogger_themes_p_90']
                break

        return float(blogger_themes_p)
