class RecommendWeightedQualityCleaned:
    def __init__(self, depth=4, weights=[0.25, 0.25, 0.25, 0.25], only_urls_in_index=False):
        self.depth = depth
        self.weights = weights
        self.only_urls_in_index = only_urls_in_index

    def value(self, metric_params):
        rec_weights = {'rel' : 1.0, 'irrel' : 0.0, 'duplicates' : 0.0, 'vdp' : 0.0}
        results = metric_params.results[:self.depth]

        metric_value = 0.0
        if self.only_urls_in_index and metric_params.serp_data["judgements.url_in_index"]['value'] == False:
            return -1
        if not results:
            return -1
        for res in results:
            pos_index = res.pos
            assert(pos_index >= 1)

            rec_value = rec_weights[res.scales.get('recrel', None)] \
                            if res.scales.get('recrel', None) else 0.0
            metric_value += rec_value * self.weights[pos_index - 1]
        return metric_value


class EmptySerps:
    def __init__(self, depth=4, weights=[0.25, 0.25, 0.25, 0.25], only_urls_in_index=False):
        self.depth = depth
        self.weights = weights
        self.only_urls_in_index = only_urls_in_index

    def value(self, metric_params):

        empty_serps_count = 0

        results = metric_params.results[:self.depth]

        if self.only_urls_in_index and metric_params.serp_data["judgements.url_in_index"]['value'] == 1 and not results:
            return 1
        else:
            return 0


class NotInIndex:
    def __init__(self, depth=4, weights=[0.25, 0.25, 0.25, 0.25], only_urls_in_index=False):
        self.depth = depth
        self.weights = weights
        self.only_urls_in_index = only_urls_in_index

    def value(self, metric_params):
        rec_weights = {'rel' : 1.0, 'irrel' : 0.0, 'duplicates' : 0.0, 'vdp' : 0.0}
        results = metric_params.results[:self.depth]

        metric_value = 0.0
        if self.only_urls_in_index and metric_params.serp_data["judgements.url_in_index"]['value'] == False:
            return 1
        else:
            return 0
