import math

class RelevanceWithVDP:
    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        relev_dict = {"RELEVANT_PLUS": 1, "RELEVANT_MINUS": 0.4, "IRRELEVANT": 0, "_404": 0, "SOFT_404": 0}

        dcg = 0

        for res in results:

            pos_index = res.pos
            assert (pos_index >= 1)

            relevance = res.scales.get('video_relevance', '_404')

            vdp_mark = res.scales.get('factor_vdp', 'OK')

            if vdp_mark != 'OK':
                continue

            dcg += relev_dict.get(relevance, 0)/ math.log((1 + pos_index), 2)

        return dcg
