class retrospective_popularity_ordering:

    def __init__(self, depth = 5, diff_order = 0.1):

        self.depth = depth
        self.diff_order = diff_order

    def value(self, metric_params):

        bad_pos_count = 0
        good_pos_count = 0

        results = metric_params.results[:self.depth]

        cur_depth = min(self.depth, len(metric_params.results))

        for up_pos in range(0, cur_depth - 1):

            if results[up_pos].scales['video_relevance'] not in ['RELEVANT_PLUS', 'RELEVANT_MINUS']:
                continue

            for low_pos in xrange(up_pos + 1, cur_depth):

                if results[low_pos].scales['video_relevance'] not in ['RELEVANT_PLUS', 'RELEVANT_MINUS']:
                    continue

                if results[low_pos].scales['video_relevance'] != results[up_pos].scales['video_relevance']:
                    continue

                up_rsp_pop = results[up_pos].scales.get("video_retrospective_popularity_3_days", 'No_info')
                low_rsp_pop = results[low_pos].scales.get("video_retrospective_popularity_3_days", 'No_info')

                if up_rsp_pop == 'No_info' or low_rsp_pop == 'No_info':
                    continue

                if (up_rsp_pop + self.diff_order) <= low_rsp_pop:
                    bad_pos_count += 1
                else:
                    good_pos_count += 1

        return good_pos_count
