class views_ordering:

    def __init__(self, depth = 5, diff_order = 5):

        self.depth = depth
        self.diff_order = diff_order

    def value(self, metric_params):

        bad_pos_count = 0
        good_pos_count = 0

        results = metric_params.results[:self.depth]

        cur_depth = min(self.depth, len(metric_params.results))

        for up_pos in range(0, cur_depth - 1):

            if results[up_pos].scales['video_relevance'] not in ['RELEVANT_PLUS', 'RELEVANT_MINUS'] or 'frontend.vh.yandex.ru' in results[up_pos].scales["componentUrl"]["pageUrl"]:
                continue

            for low_pos in range(up_pos + 1, cur_depth):

                if results[low_pos].scales['video_relevance'] not in ['RELEVANT_PLUS', 'RELEVANT_MINUS'] or 'frontend.vh.yandex.ru' in results[low_pos].scales["componentUrl"]["pageUrl"]:
                    continue

                if results[low_pos].scales['video_relevance'] != results[up_pos].scales['video_relevance']:
                    continue

                up_views = results[up_pos].scales.get('json.serpData', {}).get('views', 'No_info')
                low_views = results[low_pos].scales.get('json.serpData', {}).get('views', 'No_info')

                if up_views == 'No_info' or low_views == 'No_info' or up_views == "" or low_views == "":
                    continue

                if (int(up_views) * self.diff_order) <= int(low_views) and int(low_views) > 0:
                    bad_pos_count += 1
                else:
                    good_pos_count += 1

        return good_pos_count
