import math
import re
import json

class stivenson_ordering:

    def __init__(self, depth=5):

        self.depth = depth

        self.default_trailer_min_duration = 3 * 60
        self.default_trailer_max_duration = 5 * 60
        self.default_film_min_duration = 60 * 60
        self.default_film_max_duration = 3 * 60 * 60
        self.default_series_min_duration = 5 * 60
        self.default_series_max_duration = 60 * 60

    def value(self, metric_params):

        bad_pos_count = 0

        params = json.loads(metric_params.serp_data.get("query_param.custom_param", "{}"))

        need_piracy_fine = False
        is_film = int(params.get("is_film", "0"))
        is_serial = int(params.get("is_serial", "0"))

        if is_film or is_serial:

            if metric_params.serp_data.get('judgements.video_object_duration') and metric_params.serp_data['judgements.video_object_duration']['name'] != 'unknown':
                object_type = metric_params.serp_data['judgements.video_object_type']['name']
                object_duration = metric_params.serp_data['judgements.video_object_duration']['name']
                min_duration = float(object_duration) * 0.8
                max_duration = float(object_duration) * 1.2
            else:
                if is_film:
                    min_duration = self.default_film_min_duration
                    max_duration = self.default_film_max_duration
                else:
                    min_duration = self.default_series_min_duration
                    max_duration = self.default_series_max_duration

            cur_depth = min(self.depth, len(metric_params.results))

            results = metric_params.results[:cur_depth]
            stivenson_dict = {}
            pos = 0

            for res in results:

                piracy = res.scales.get("player_stivenson_type")

                if not res.scales.get("text.videoDuration"):
                    duration = 0
                else:
                    convert_to_seconds=[1, 60, 3600]
                    duration = sum(int(x)*y for x, y in zip(res.scales.get("text.videoDuration").split(':')[::-1],
                                                            convert_to_seconds))

                is_content = 1 if duration >= min_duration and duration <= max_duration else 0
                is_trailer = 1 if duration >= self.default_trailer_min_duration and duration <= self.default_trailer_max_duration else 0

                player_id = res.scales.get("text.playerId", "no_playerID")

                if 'moonwalk' in player_id.lower() or 'hdgo' in player_id.lower():
                    weight = 0
                elif piracy == "pirate" and (is_content or is_trailer):
                    weight = 1
                elif piracy == "semi_pirate" and (is_content or is_trailer):
                    if is_content and is_trailer:
                        weight = is_content * 3
                    else:
                        weight = is_content * 3 + is_trailer * 2
                elif piracy == "not pirate" and (is_content or is_trailer):
                    if is_content and is_trailer:
                        weight = is_content * 5
                    else:
                        weight = is_content * 5 + is_trailer * 4
                else:
                    weight = 10

                stivenson_dict[pos] = weight

                pos += 1

            for up_pos in xrange(0, len(stivenson_dict) - 1):

                if stivenson_dict[up_pos] == 10:
                    continue

                for low_pos in xrange(up_pos + 1, len(stivenson_dict)):
                    if stivenson_dict[low_pos] == 10:
                        continue

                    if stivenson_dict[up_pos] < stivenson_dict[low_pos]:
                        bad_pos_count += 1

            return bad_pos_count

        else:
            return 0

