class asessors_accuracy_monitoring:

    def __init__(self, depth=1):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        correct_assessments = 0
        total_assessments = 0

        for res in results:
            if not res.scales['collections_feed_pointwise_label']:
                continue
            total_assessments += 1
            if res.scales['etalon_result'] == '+2' and res.scales['collections_feed_pointwise_label'] != '-2':
                correct_assessments += 1
            elif res.scales['etalon_result'] == '-2' and res.scales['collections_feed_pointwise_label'] == '-2':
                correct_assessments += 1
            elif res.scales['etalon_result'] == '-1' and res.scales['collections_feed_pointwise_label'] != '+2':
                correct_assessments += 1

        if total_assessments:
            return correct_assessments * 100.0 / total_assessments
