class vh_vdp_share:

    def __init__(self, depth = 5, flag = 0):

        self.depth = depth
        self.flag = flag

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        vh_vdp = 0
        bin_vh_vdp = 0
        total = 0

        for res in results:

            url = res.scales.get("componentUrl", {}).get("pageUrl")

            if "frontend.vh" in url or 'ott-widget' in url:
                total += 1

                if res.scales.get('video_relevance', "none") == '_404' or res.scales.get('video_relevance', "none") == 'SOFT_404':
                    vh_vdp += 1

                if res.scales.get('video_relevance_bin', "none") == "404":
                    bin_vh_vdp += 1

        if total != 0:
            if self.flag == 0:
                return vh_vdp * 100.0 / total
            else:
                return bin_vh_vdp * 100.0 / total
        else:
            return -1
