class irrel_share:

    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        vh_irrel = 0
        vh_total = 0

        for res in results:
            url = res.scales["componentUrl"]["pageUrl"]

            if 'frontend.vh.yandex' in url or 'ott-widget.yandex' in url:
                vh_total += 1
                if res.scales.get('video_relevance', 'no_assessment') == "IRRELEVANT":
                    vh_irrel += 1

        if vh_total:
            return vh_irrel * 100.0 / vh_total
