import math
import json

class VideoKernel:
    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        def get_kernel(albin_host_bundle):
            visitors = json.loads(albin_host_bundle).get("visitors", 0.)

            if not visitors:
                visitors = 0

            kessel_odd_factor160 = json.loads(albin_host_bundle).get("kessel_odd_factor160", 0.)

            return (kessel_odd_factor160 * visitors + 0.486 * 0.0013) / (visitors + 0.0013) - 0.486


        results = metric_params.results[:self.depth]

        max_dcg = sum([1.0 / math.log(2 + pos) for pos in range(self.depth)])

        dcg = 0

        for res in results:

            pos_index = res.pos
            assert (pos_index >= 1)

            relevance = res.scales.get('video_relevance', '_404')

            if relevance != 'RELEVANT_PLUS':
                continue

            dcg += get_kernel(res.scales.get('video_albin_host_bundle',"{}")) / math.log(1 + pos_index)

        return dcg / max_dcg
