import math
import re
import json

class RelevanceFreshness:
    def __init__(self, depth=5,
                 freshness_always_fine=0.5,
                 freshness_tmp_fine=0,
                 boost_value=0.3,):

        self.depth = depth
        self.freshness_always_fine = freshness_always_fine
        self.freshness_tmp_fine = freshness_tmp_fine

        self.boost_value = boost_value


    def value(self, metric_params):

        def freshness_fine(params, source_freshness):

            freshness_coef = 1

            is_always_freshness = int(params.get("is_always_freshness", "0"))
            is_tmp_freshness = int(params.get("is_tmp_freshness", "0"))

            if is_always_freshness == 1 and source_freshness not in ['VIDEOQUICK', 'VIDEOQUICK_MISSPELL']:
                freshness_coef = self.freshness_always_fine
            elif is_tmp_freshness == 1 and source_freshness not in ['VIDEOQUICK', 'VIDEOQUICK_MISSPELL']:
                freshness_coef = self.freshness_tmp_fine

            return freshness_coef


        REL_MINUS_WEIGHT = 0.7
        BOOST_VALUE = self.boost_value

        def num_value(label, middle_mark_weight):

            v = {'RELEVANT_PLUS': 1.0, 'RELEVANT_MINUS': middle_mark_weight, 'IRRELEVANT': 0.0, \
                     'SOFT_404': 0.0, '_404': 0.0, 'VIRUS' : 0.0}

            return v[label]

        results = metric_params.results[:self.depth]
        params = json.loads(metric_params.serp_data.get("serp_query_param.custom_param", "{}"))

        max_dcg = (1.0 + BOOST_VALUE) * sum([1.0 / math.log(2 + pos) for pos in range(self.depth)])

        dcg = 0

        for res in results:
            pos_index = res.pos
            assert (pos_index >= 1)

            relevance = res.scales.get("video_relevance", '_404')
            rel_value = num_value(relevance, REL_MINUS_WEIGHT)

            fresh_fine = freshness_fine(params, res.scales.get('text.SERVER_DESCR', ''))

            if pos_index < 4:
                dcg += fresh_fine * rel_value / math.log(1 + pos_index)
            else:
                dcg += rel_value / math.log(1 + pos_index)

        return dcg / max_dcg
