# -*- coding: utf-8 -*-

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf
import argparse
import nile
import datetime
import uatraits, json, re
import urllib, urlparse
import math,cgi
import pandas as pd
from itertools import product
import sys
import os


cluster = clusters.yt.Arnold(pool='vika-pavlova'
    ).env(templates=dict(job_root='home/videolog/vika-pavlova/2394-report_from_redir_log'
                        ),
          yt_spec_defaults=dict(pool_trees=["physical"],
                                #tentative_pool_trees=["cloud"]),
                                use_default_tentative_pool_trees = True),
          parallel_operations_limit=10
         )


def exists_and_not_empty(path, yt):
    return yt.exists(path) and not yt.is_empty(path)


def wait_fot_user_subs(date):

  yt = cluster.driver.client
  while 1:
      if exists_and_not_empty('//home/videolog/24julia/mma-3107/1.parsed_us/' + date, yt):
          print 'yes'
          break

  while 1:
      if exists_and_not_empty('//home/videolog/24julia/mma-3107/1.parsed_us/' + date, yt):
          print 'yes'
          break


def main():

    parser = argparse.ArgumentParser()
    parser.add_argument('--start_date', type=str, required=True)
    parser.add_argument('--end_date', type=str, required=True)
    args = parser.parse_args()

    for date in pd.date_range(start=args.start_date, end=args.end_date):
        date_str = str(date)[:10]
        wait_fot_user_subs(date_str)


if __name__ == '__main__':
    main()
