from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf
import argparse
import nile
import datetime
import uatraits, json, re
import urllib, urlparse
import math,cgi
import pandas as pd
from itertools import product
import sys
import os


def process_data_for_stat(date):

    cluster = clusters.yt.Hahn(
                            ).env(templates=dict(job_root='home/videolog/vika-pavlova/2205-wizard_doubles/all_dates'),
                                  yt_spec_defaults=dict(pool_trees=["physical"],
                                                        tentative_pool_trees=["cloud"]
                                                       ),
                                  parallel_operations_limit=10
                                  )

    job = cluster.job()

    reqs = job.table('home/videolog/vika-pavlova/one_us_parse_for_all_reports/2205_wiz_doubles_' + date)

    aggr_by_reqid = reqs.groupby('date', 'ui', 'reqid', 'filmid'
                ).aggregate(filmids_count=na.count()
                           )

    temp = aggr_by_reqid.groupby('date', 'reqid', 'ui'
                                ).aggregate(doubles_count=na.count(predicate=nf.custom(lambda x: x > 1, 'filmids_count')),
                                            unique_count=na.count(predicate=nf.custom(lambda x: x == 1, 'filmids_count'))
                                           )

    temp.groupby('date', 'ui'
                ).aggregate(bad_reqids=na.count(predicate=nf.custom(lambda x: x > 0, 'doubles_count')),
                            all_reqids=na.count()
                        ).project('ui', 'bad_reqids', 'all_reqids',
                                    fielddate=ne.custom(lambda a: a, 'date')
                                    ).sort('ui').put('$job_root/final_for_stat_' + date)

    job.run()


def put_data_to_stat(date):

    client = ns.StatfaceClient(
        proxy = 'upload.stat.yandex-team.ru',
        token = os.environ['STAT_TOKEN']
    )
    ns.StatfaceReport().path('Video.All/wizard_doubles_reqids_share') \
                       .scale('daily') \
                       .client(client) \
                       .remote_publish(proxy='hahn',
                                       table_path='//home/videolog/vika-pavlova/2205-wizard_doubles/all_dates/final_for_stat_' + date,
                                       async_mode=False,
                                       upload_config=False)


def main():

    parser = argparse.ArgumentParser()
    parser.add_argument('--start_date', type=str, required=True)
    parser.add_argument('--end_date', type=str, required=True)
    args = parser.parse_args()

    for date in pd.date_range(start=args.start_date, end=args.end_date):
        date_str = str(date)[:10]
        process_data_for_stat(date_str)
        put_data_to_stat(date_str)


if __name__ == '__main__':
    main()
